/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.webapp.taglib;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Form;
import org.apache.commons.validator.ValidatorResources;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.validation.Errors;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.support.RequestContext;
import org.springmodules.validation.commons.ValidatorFactory;

public class LabelTag
extends TagSupport {
    private static final long serialVersionUID = -5310144023136517119L;
    protected RequestContext requestContext;
    protected final transient Log log = LogFactory.getLog(LabelTag.class);
    protected String key = null;
    protected String styleClass = null;
    protected String errorClass = null;
    protected boolean colon = false;

    public int doStartTag() throws JspException {
        Field field;
        Form form;
        try {
            this.requestContext = new RequestContext((HttpServletRequest)this.pageContext.getRequest());
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.pageContext.getServletContext().log("Exception in custom tag", (Throwable)ex);
        }
        boolean requiredField = false;
        boolean validationError = false;
        ValidatorResources resources = this.getValidatorResources();
        Locale locale = this.pageContext.getRequest().getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String formName = this.key.substring(0, this.key.indexOf(46));
        String fieldName = this.key.substring(formName.length() + 1);
        if (resources != null && (form = resources.getForm(locale, formName)) != null && (field = form.getField(fieldName)) != null && (field.isDependency("required") || field.isDependency("validwhen"))) {
            requiredField = true;
        }
        Errors errors = this.requestContext.getErrors(formName, false);
        List fes = null;
        if (errors != null) {
            fes = errors.getFieldErrors(fieldName);
        }
        if (fes != null && fes.size() > 0) {
            validationError = true;
        }
        String message = null;
        try {
            message = this.getMessageSource().getMessage(this.key, null, locale);
        }
        catch (NoSuchMessageException nsm) {
            message = "???" + this.key + "???";
        }
        String cssClass = null;
        if (this.styleClass != null) {
            cssClass = this.styleClass;
        } else if (requiredField) {
            cssClass = "required";
        }
        String cssErrorClass = this.errorClass != null ? this.errorClass : "error";
        StringBuilder label = new StringBuilder();
        if (message == null || "".equals(message.trim())) {
            label.append("");
        } else {
            label.append("<label for=\"").append(fieldName).append("\"");
            if (cssClass != null) {
                label.append(" class=\"").append(cssClass);
                if (validationError) {
                    label.append(" ").append(cssErrorClass);
                }
            }
            label.append("\">").append(message);
            label.append(requiredField ? " <span class=\"required\">*</span>" : "");
            label.append(this.colon ? ":" : "");
            label.append("</label>");
        }
        try {
            this.writeMessage(label.toString());
        }
        catch (IOException io) {
            io.printStackTrace();
            throw new JspException("Error writing label: " + io.getMessage());
        }
        return 0;
    }

    protected void writeMessage(String msg) throws IOException {
        this.pageContext.getOut().write(msg);
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setColon(boolean colon) {
        this.colon = colon;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public void setErrorClass(String errorClass) {
        this.errorClass = errorClass;
    }

    public void release() {
        super.release();
        this.key = null;
        this.colon = false;
        this.styleClass = null;
        this.errorClass = null;
    }

    private ValidatorResources getValidatorResources() {
        WebApplicationContext ctx = (WebApplicationContext)this.pageContext.getRequest().getAttribute(DispatcherServlet.WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        ValidatorFactory factory = null;
        try {
            factory = (ValidatorFactory)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)ctx, ValidatorFactory.class, (boolean)true, (boolean)true);
        }
        catch (NoSuchBeanDefinitionException e) {
            ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.pageContext.getServletContext());
            factory = (ValidatorFactory)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)ctx, ValidatorFactory.class, (boolean)true, (boolean)true);
        }
        return factory.getValidatorResources();
    }

    private MessageSource getMessageSource() {
        return this.requestContext.getWebApplicationContext();
    }
}

