/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.webapp.controller;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import org.appfuse.Constants;
import org.appfuse.webapp.controller.BaseFormController;
import org.appfuse.webapp.controller.FileUpload;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

@Controller
@RequestMapping(value={"/fileupload*"})
public class FileUploadController
extends BaseFormController {
    public FileUploadController() {
        this.setCancelView("redirect:/home");
        this.setSuccessView("uploadDisplay");
    }

    @ModelAttribute
    @RequestMapping(method={RequestMethod.GET})
    public FileUpload showForm() {
        return new FileUpload();
    }

    @RequestMapping(method={RequestMethod.POST})
    public String onSubmit(FileUpload fileUpload, BindingResult errors, HttpServletRequest request) throws Exception {
        int bytesRead;
        File dirPath;
        if (request.getParameter("cancel") != null) {
            return this.getCancelView();
        }
        if (this.validator != null) {
            this.validator.validate((Object)fileUpload, (Errors)errors);
            if (errors.hasErrors()) {
                return "fileupload";
            }
        }
        if (fileUpload.getFile().length == 0) {
            Object[] args = new Object[]{this.getText("uploadForm.file", request.getLocale())};
            errors.rejectValue("file", "errors.required", args, "File");
            return "fileupload";
        }
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        CommonsMultipartFile file = (CommonsMultipartFile)multipartRequest.getFile("file");
        String uploadDir = this.getServletContext().getRealPath("/resources");
        if (uploadDir == null) {
            uploadDir = new File("src/main/webapp/resources").getAbsolutePath();
        }
        if (!(dirPath = new File(uploadDir = uploadDir + "/" + request.getRemoteUser() + "/")).exists()) {
            dirPath.mkdirs();
        }
        InputStream stream = file.getInputStream();
        FileOutputStream bos = new FileOutputStream(uploadDir + file.getOriginalFilename());
        byte[] buffer = new byte[8192];
        while ((bytesRead = stream.read(buffer, 0, 8192)) != -1) {
            ((OutputStream)bos).write(buffer, 0, bytesRead);
        }
        ((OutputStream)bos).close();
        stream.close();
        request.setAttribute("friendlyName", (Object)fileUpload.getName());
        request.setAttribute("fileName", (Object)file.getOriginalFilename());
        request.setAttribute("contentType", (Object)file.getContentType());
        request.setAttribute("size", (Object)(file.getSize() + " bytes"));
        request.setAttribute("location", (Object)(dirPath.getAbsolutePath() + Constants.FILE_SEP + file.getOriginalFilename()));
        String link = request.getContextPath() + "/resources" + "/" + request.getRemoteUser() + "/";
        request.setAttribute("link", (Object)(link + file.getOriginalFilename()));
        return this.getSuccessView();
    }
}

