/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.webapp.controller;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.appfuse.model.User;
import org.appfuse.webapp.controller.BaseFormController;
import org.appfuse.webapp.util.RequestUtil;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class UpdatePasswordController
extends BaseFormController {
    public static final String RECOVERY_PASSWORD_TEMPLATE = "/updatePassword?username={username}&token={token}";

    @RequestMapping(value={"/requestRecoveryToken*"}, method={RequestMethod.GET})
    public String requestRecoveryToken(@RequestParam(value="username", required=true) String username, HttpServletRequest request) {
        this.log.debug((Object)("Sending recovery token to user " + username));
        try {
            this.getUserManager().sendPasswordRecoveryEmail(username, RequestUtil.getAppURL((HttpServletRequest)request) + RECOVERY_PASSWORD_TEMPLATE);
        }
        catch (UsernameNotFoundException usernameNotFoundException) {
            // empty catch block
        }
        this.saveMessage(request, this.getText("updatePassword.recoveryToken.sent", request.getLocale()));
        return "redirect:/";
    }

    @RequestMapping(value={"/updatePassword*"}, method={RequestMethod.GET})
    public ModelAndView showForm(@RequestParam(value="username", required=false) String username, @RequestParam(value="token", required=false) String token, HttpServletRequest request) {
        if (StringUtils.isBlank((String)username)) {
            username = request.getRemoteUser();
        }
        if (StringUtils.isNotBlank((String)token) && !this.getUserManager().isRecoveryTokenValid(username, token)) {
            this.saveError(request, this.getText("updatePassword.invalidToken", request.getLocale()));
            return new ModelAndView("redirect:/");
        }
        return new ModelAndView("updatePasswordForm").addObject("username", (Object)username).addObject("token", (Object)token);
    }

    @RequestMapping(value={"/updatePassword*"}, method={RequestMethod.POST})
    public ModelAndView onSubmit(@RequestParam(value="username", required=true) String username, @RequestParam(value="token", required=false) String token, @RequestParam(value="currentPassword", required=false) String currentPassword, @RequestParam(value="password", required=true) String password, HttpServletRequest request) throws Exception {
        this.log.debug((Object)("PasswordRecoveryController onSubmit for username: " + username));
        Locale locale = request.getLocale();
        if (StringUtils.isEmpty((String)password)) {
            this.saveError(request, this.getText("errors.required", this.getText("updatePassword.newPassword.label", locale), locale));
            return this.showForm(username, null, request);
        }
        User user = null;
        boolean usingToken = StringUtils.isNotBlank((String)token);
        if (usingToken) {
            this.log.debug((Object)("Updating Password for username " + username + ", using reset token"));
            user = this.getUserManager().updatePassword(username, null, token, password, RequestUtil.getAppURL((HttpServletRequest)request));
        } else {
            this.log.debug((Object)("Updating Password for username " + username + ", using current password"));
            if (!username.equals(request.getRemoteUser())) {
                throw new AccessDeniedException("You do not have permission to modify other users password.");
            }
            user = this.getUserManager().updatePassword(username, currentPassword, null, password, RequestUtil.getAppURL((HttpServletRequest)request));
        }
        if (user != null) {
            this.saveMessage(request, this.getText("updatePassword.success", new Object[]{username}, locale));
        } else if (usingToken) {
            this.saveError(request, this.getText("updatePassword.invalidToken", locale));
        } else {
            this.saveError(request, this.getText("updatePassword.invalidPassword", locale));
            return this.showForm(username, null, request);
        }
        return new ModelAndView("redirect:/");
    }
}

