/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.webapp.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocaleRequestWrapper
extends HttpServletRequestWrapper {
    private final transient Log log = LogFactory.getLog(LocaleRequestWrapper.class);
    private final Locale preferredLocale;

    public LocaleRequestWrapper(HttpServletRequest decorated, Locale userLocale) {
        super(decorated);
        this.preferredLocale = userLocale;
        if (null == this.preferredLocale) {
            this.log.error((Object)"preferred locale = null, it is an unexpected value!");
        }
    }

    public Locale getLocale() {
        if (null != this.preferredLocale) {
            return this.preferredLocale;
        }
        return super.getLocale();
    }

    public Enumeration<Locale> getLocales() {
        if (null != this.preferredLocale) {
            ArrayList l = Collections.list(super.getLocales());
            if (l.contains(this.preferredLocale)) {
                l.remove(this.preferredLocale);
            }
            l.add(0, this.preferredLocale);
            return Collections.enumeration(l);
        }
        return super.getLocales();
    }
}

