/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.webapp.action;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.appfuse.model.User;
import org.appfuse.webapp.action.BaseAction;
import org.appfuse.webapp.util.RequestUtil;

public class PasswordHintAction
extends BaseAction {
    private static final long serialVersionUID = -4037514607101222025L;
    private String username;

    public void setUsername(String username) {
        this.username = username;
    }

    public String execute() {
        ArrayList<String> args = new ArrayList<String>();
        if (this.username == null) {
            this.log.warn((Object)"Username not specified, notifying user that it's a required field.");
            args.add(this.getText("user.username"));
            this.addActionError(this.getText("errors.required", args));
            return "input";
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Processing Password Hint...");
        }
        try {
            User user = this.userManager.getUserByUsername(this.username);
            StringBuffer msg = new StringBuffer();
            msg.append("Your password hint is: " + user.getPasswordHint());
            msg.append("\n\nLogin at: " + RequestUtil.getAppURL((HttpServletRequest)this.getRequest()));
            this.message.setTo(user.getEmail());
            String subject = '[' + this.getText("webapp.name") + "] " + this.getText("user.passwordHint");
            this.message.setSubject(subject);
            this.message.setText(msg.toString());
            this.mailEngine.send(this.message);
            args.add(this.username);
            args.add(user.getEmail());
            this.saveMessage(this.getText("login.passwordHint.sent", args));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.addActionError(this.getText("login.passwordHint.error", args));
        }
        return "success";
    }
}

