/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.webapp.action;

import com.opensymphony.xwork2.ActionSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.appfuse.model.User;
import org.appfuse.service.MailEngine;
import org.appfuse.service.RoleManager;
import org.appfuse.service.UserManager;
import org.springframework.mail.SimpleMailMessage;

public class BaseAction
extends ActionSupport {
    private static final long serialVersionUID = 3525445612504421307L;
    public static final String CANCEL = "cancel";
    protected final transient Log log = LogFactory.getLog(this.getClass());
    protected UserManager userManager = null;
    protected RoleManager roleManager = null;
    protected String from = null;
    protected String cancel = null;
    protected String delete = null;
    protected String save = null;
    protected MailEngine mailEngine = null;
    protected SimpleMailMessage mailMessage = null;
    protected String templateName = null;

    public String cancel() {
        return CANCEL;
    }

    protected void saveMessage(String msg) {
        ArrayList<String> messages = (ArrayList<String>)this.getRequest().getSession().getAttribute("messages");
        if (messages == null) {
            messages = new ArrayList<String>();
        }
        messages.add(msg);
        this.getRequest().getSession().setAttribute("messages", messages);
    }

    protected Map getConfiguration() {
        HashMap config = (HashMap)this.getSession().getServletContext().getAttribute("appConfig");
        if (config == null) {
            return new HashMap();
        }
        return config;
    }

    protected HttpServletRequest getRequest() {
        return ServletActionContext.getRequest();
    }

    protected HttpServletResponse getResponse() {
        return ServletActionContext.getResponse();
    }

    protected HttpSession getSession() {
        return this.getRequest().getSession();
    }

    protected void sendUserMessage(User user, String msg, String url) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("sending e-mail to user [" + user.getEmail() + "]..."));
        }
        this.mailMessage.setTo(user.getFullName() + "<" + user.getEmail() + ">");
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("user", user);
        model.put("message", msg);
        model.put("applicationURL", url);
        this.mailEngine.sendMessage(this.mailMessage, this.templateName, model);
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public void setRoleManager(RoleManager roleManager) {
        this.roleManager = roleManager;
    }

    public void setMailEngine(MailEngine mailEngine) {
        this.mailEngine = mailEngine;
    }

    public void setMailMessage(SimpleMailMessage mailMessage) {
        this.mailMessage = mailMessage;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setDelete(String delete) {
        this.delete = delete;
    }

    public void setSave(String save) {
        this.save = save;
    }
}

