/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.webapp.action;

import java.util.ArrayList;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.ProviderManager;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.apache.struts2.ServletActionContext;
import org.appfuse.model.User;
import org.appfuse.service.UserExistsException;
import org.appfuse.util.StringUtil;
import org.appfuse.webapp.action.BaseAction;
import org.appfuse.webapp.util.RequestUtil;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SignupAction
extends BaseAction {
    private static final long serialVersionUID = 6558317334878272308L;
    private User user;
    private String cancel;

    public void setCancel(String cancel) {
        this.cancel = cancel;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public User getUser() {
        return this.user;
    }

    public String execute() {
        if (this.cancel != null) {
            return "cancel";
        }
        if (ServletActionContext.getRequest().getMethod().equals("GET")) {
            return "input";
        }
        return "success";
    }

    public String doDefault() {
        return "input";
    }

    public String save() throws Exception {
        Boolean encrypt = (Boolean)this.getConfiguration().get("encryptPassword");
        if (encrypt != null && encrypt.booleanValue()) {
            String algorithm = (String)this.getConfiguration().get("algorithm");
            if (algorithm == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"assuming testcase, setting algorithm to 'SHA'");
                }
                algorithm = "SHA";
            }
            this.user.setPassword(StringUtil.encodePassword((String)this.user.getPassword(), (String)algorithm));
        }
        this.user.setEnabled(true);
        this.user.addRole(this.roleManager.getRole("user"));
        try {
            this.userManager.saveUser(this.user);
        }
        catch (UserExistsException e) {
            this.log.warn((Object)e.getMessage());
            ArrayList<String> args = new ArrayList<String>();
            args.add(this.user.getUsername());
            args.add(this.user.getEmail());
            this.addActionError(this.getText("errors.existing.user", args));
            this.user.setPassword(this.user.getConfirmPassword());
            return "input";
        }
        this.saveMessage(this.getText("user.registered"));
        this.getSession().setAttribute("registered", (Object)Boolean.TRUE);
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)this.user.getUsername(), (Object)this.user.getConfirmPassword());
        try {
            WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getSession().getServletContext());
            if (ctx != null) {
                ProviderManager authenticationManager = (ProviderManager)ctx.getBean("authenticationManager");
                SecurityContextHolder.getContext().setAuthentication(authenticationManager.doAuthentication((Authentication)auth));
            }
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        this.mailMessage.setSubject(this.getText("signup.email.subject"));
        this.sendUserMessage(this.user, this.getText("signup.email.message"), RequestUtil.getAppURL((HttpServletRequest)this.getRequest()));
        return "success";
    }
}

