/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.webapp.taglib;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import org.appfuse.model.LabelValue;
import org.appfuse.webapp.taglib.CountryTag;
import org.displaytag.tags.el.ExpressionEvaluator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CountryTag
extends TagSupport {
    private static final long serialVersionUID = 3905528206810167095L;
    private String name;
    private String prompt;
    private String scope;
    private String selected;

    public void setName(String name) {
        this.name = name;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public void setDefault(String selected) {
        this.selected = selected;
    }

    public void setToScope(String scope) {
        this.scope = scope;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int doStartTag() throws JspException {
        ExpressionEvaluator eval = new ExpressionEvaluator((Tag)this, this.pageContext);
        if (this.selected != null) {
            this.selected = eval.evalString("default", this.selected);
        }
        Locale userLocale = this.pageContext.getRequest().getLocale();
        List countries = this.buildCountryList(userLocale);
        if (this.scope != null) {
            if (this.scope.equals("page")) {
                this.pageContext.setAttribute(this.name, (Object)countries);
                return super.doStartTag();
            } else if (this.scope.equals("request")) {
                this.pageContext.getRequest().setAttribute(this.name, (Object)countries);
                return super.doStartTag();
            } else if (this.scope.equals("session")) {
                this.pageContext.getSession().setAttribute(this.name, (Object)countries);
                return super.doStartTag();
            } else {
                if (!this.scope.equals("application")) throw new JspException("Attribute 'scope' must be: page, request, session or application");
                this.pageContext.getServletContext().setAttribute(this.name, (Object)countries);
            }
            return super.doStartTag();
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<select name=\"" + this.name + "\" id=\"" + this.name + "\" class=\"select\">\n");
        if (this.prompt != null) {
            sb.append("    <option value=\"\" selected=\"selected\">");
            sb.append(eval.evalString("prompt", this.prompt) + "</option>\n");
        }
        for (LabelValue country : countries) {
            sb.append("    <option value=\"" + country.getValue() + "\"");
            if (this.selected != null && this.selected.equals(country.getValue())) {
                sb.append(" selected=\"selected\"");
            }
            sb.append(">" + country.getLabel() + "</option>\n");
        }
        sb.append("</select>");
        try {
            this.pageContext.getOut().write(sb.toString());
            return super.doStartTag();
        }
        catch (IOException io) {
            throw new JspException((Throwable)io);
        }
    }

    public void release() {
        super.release();
    }

    protected List<LabelValue> buildCountryList(Locale locale) {
        String EMPTY = "";
        Locale[] available = Locale.getAvailableLocales();
        ArrayList<LabelValue> countries = new ArrayList<LabelValue>();
        for (int i = 0; i < available.length; ++i) {
            LabelValue country;
            String iso = available[i].getCountry();
            String name = available[i].getDisplayCountry(locale);
            if ("".equals(iso) || "".equals(name) || countries.contains(country = new LabelValue(name, iso))) continue;
            countries.add(new LabelValue(name, iso));
        }
        Collections.sort(countries, new LabelValueComparator(this, locale));
        return countries;
    }
}

