/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.webapp.action;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.struts2.ServletActionContext;
import org.appfuse.Constants;
import org.appfuse.webapp.action.BaseAction;

public class FileUploadAction
extends BaseAction {
    private static final long serialVersionUID = -9208910183310010569L;
    private File file;
    private String fileContentType;
    private String fileFileName;
    private String name;

    public String upload() throws Exception {
        int bytesRead;
        if (this.cancel != null) {
            return "cancel";
        }
        String uploadDir = ServletActionContext.getServletContext().getRealPath("/resources") + "/" + this.getRequest().getRemoteUser() + "/";
        File dirPath = new File(uploadDir);
        if (!dirPath.exists()) {
            dirPath.mkdirs();
        }
        FileInputStream stream = new FileInputStream(this.file);
        FileOutputStream bos = new FileOutputStream(uploadDir + this.fileFileName);
        byte[] buffer = new byte[8192];
        while ((bytesRead = ((InputStream)stream).read(buffer, 0, 8192)) != -1) {
            ((OutputStream)bos).write(buffer, 0, bytesRead);
        }
        ((OutputStream)bos).close();
        ((InputStream)stream).close();
        this.getRequest().setAttribute("location", (Object)(dirPath.getAbsolutePath() + Constants.FILE_SEP + this.fileFileName));
        String link = this.getRequest().getContextPath() + "/resources" + "/" + this.getRequest().getRemoteUser() + "/";
        this.getRequest().setAttribute("link", (Object)(link + this.fileFileName));
        return "success";
    }

    public String execute() {
        return "input";
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setFileContentType(String fileContentType) {
        this.fileContentType = fileContentType;
    }

    public void setFileFileName(String fileFileName) {
        this.fileFileName = fileFileName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public File getFile() {
        return this.file;
    }

    public String getFileContentType() {
        return this.fileContentType;
    }

    public String getFileFileName() {
        return this.fileFileName;
    }

    public void validate() {
        if (this.getRequest().getMethod().equalsIgnoreCase("post")) {
            this.getFieldErrors().clear();
            if ("".equals(this.fileFileName) || this.file == null) {
                super.addFieldError("file", this.getText("errors.requiredField", new String[]{this.getText("uploadForm.file")}));
            } else if (this.file.length() > 0x200000L) {
                this.addActionError(this.getText("maxLengthExceeded"));
            }
        }
    }
}

