/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.webapp.filter;

import java.io.IOException;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.PatternMatchUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.UrlPathHelper;

public class StaticFilter
extends OncePerRequestFilter {
    private static final String DEFAULT_INCLUDES = "*.html";
    private static final String DEFAULT_EXCLUDES = "";
    private static final String INCLUDES_PARAMETER = "includes";
    private static final String EXCLUDES_PARAMETER = "excludes";
    private static final String SERVLETNAME_PARAMETER = "servletName";
    private String[] excludes;
    private String[] includes;
    private String servletName = null;

    public void initFilterBean() {
        String includesParam = this.getFilterConfig().getInitParameter(INCLUDES_PARAMETER);
        this.includes = StringUtils.isEmpty((String)includesParam) ? this.parsePatterns(DEFAULT_INCLUDES) : this.parsePatterns(includesParam);
        String excludesParam = this.getFilterConfig().getInitParameter(EXCLUDES_PARAMETER);
        this.excludes = StringUtils.isEmpty((String)excludesParam) ? this.parsePatterns(DEFAULT_EXCLUDES) : this.parsePatterns(excludesParam);
        this.servletName = this.getFilterConfig().getInitParameter(SERVLETNAME_PARAMETER);
    }

    private String[] parsePatterns(String delimitedPatterns) {
        Set patternSet = org.springframework.util.StringUtils.commaDelimitedListToSet((String)delimitedPatterns);
        String[] patterns = new String[patternSet.size()];
        int i = 0;
        for (String pattern : patternSet) {
            patterns[i] = pattern.trim();
            ++i;
        }
        return patterns;
    }

    public void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        UrlPathHelper urlPathHelper = new UrlPathHelper();
        String path = urlPathHelper.getPathWithinApplication(request);
        boolean pathExcluded = PatternMatchUtils.simpleMatch((String[])this.excludes, (String)path);
        boolean pathIncluded = PatternMatchUtils.simpleMatch((String[])this.includes, (String)path);
        if (pathIncluded && !pathExcluded) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Forwarding to static resource: " + path));
            }
            if (path.contains(".html")) {
                response.setContentType("text/html");
            }
            RequestDispatcher rd = this.getServletContext().getRequestDispatcher(path);
            rd.include((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (this.servletName != null) {
            RequestDispatcher rd = this.getServletContext().getNamedDispatcher(this.servletName);
            rd.forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

