/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.webapp.interceptor;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.Interceptor;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.ServletActionContext;

public class UserRoleAuthorizationInterceptor
implements Interceptor {
    private static final long serialVersionUID = 5067790608840427509L;
    private String[] authorizedRoles;

    public String intercept(ActionInvocation invocation) throws Exception {
        HttpServletRequest request = ServletActionContext.getRequest();
        if (this.authorizedRoles != null) {
            for (String authorizedRole : this.authorizedRoles) {
                if (!request.isUserInRole(authorizedRole)) continue;
                return invocation.invoke();
            }
        }
        HttpServletResponse response = ServletActionContext.getResponse();
        this.handleNotAuthorized(request, response);
        return null;
    }

    public final void setAuthorizedRoles(String[] authorizedRoles) {
        this.authorizedRoles = authorizedRoles;
    }

    protected void handleNotAuthorized(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.sendError(403);
    }

    public void destroy() {
    }

    public void init() {
    }
}

