/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.webapp.action;

import com.opensymphony.xwork2.Preparable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationTrustResolverImpl;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.struts2.ServletActionContext;
import org.appfuse.model.Role;
import org.appfuse.model.User;
import org.appfuse.service.UserExistsException;
import org.appfuse.webapp.action.BaseAction;
import org.appfuse.webapp.util.RequestUtil;
import org.springframework.mail.MailException;

public class UserAction
extends BaseAction
implements Preparable {
    private static final long serialVersionUID = 6776558938712115191L;
    private List users;
    private User user;
    private String id;

    public void prepare() {
        if (this.getRequest().getMethod().equalsIgnoreCase("post") && !"".equals(this.getRequest().getParameter("user.id"))) {
            this.user = this.userManager.getUser(this.getRequest().getParameter("user.id"));
        }
    }

    public List getUsers() {
        return this.users;
    }

    public void setId(String id) {
        this.id = id;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public String delete() {
        this.userManager.removeUser(this.user.getId().toString());
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.user.getFullName());
        this.saveMessage(this.getText("user.deleted", args));
        return "success";
    }

    public String edit() throws IOException {
        boolean editProfile;
        HttpServletRequest request = this.getRequest();
        boolean bl = editProfile = request.getRequestURI().indexOf("editProfile") > -1;
        if (editProfile && (request.getParameter("id") != null || request.getParameter("from") != null)) {
            ServletActionContext.getResponse().sendError(403);
            this.log.warn((Object)("User '" + request.getRemoteUser() + "' is trying to edit user '" + request.getParameter("id") + "'"));
            return null;
        }
        if (this.id != null) {
            this.user = this.userManager.getUser(this.id);
        } else if (editProfile) {
            this.user = this.userManager.getUserByUsername(request.getRemoteUser());
        } else {
            this.user = new User();
            this.user.addRole(new Role("ROLE_USER"));
        }
        if (this.user.getUsername() != null) {
            Authentication auth;
            this.user.setConfirmPassword(this.user.getPassword());
            this.log.debug((Object)"checking for remember me login...");
            AuthenticationTrustResolverImpl resolver = new AuthenticationTrustResolverImpl();
            SecurityContext ctx = SecurityContextHolder.getContext();
            if (ctx != null && resolver.isRememberMe(auth = ctx.getAuthentication())) {
                this.getSession().setAttribute("cookieLogin", (Object)"true");
                this.saveMessage(this.getText("userProfile.cookieLogin"));
            }
        }
        return "success";
    }

    public String execute() {
        return "success";
    }

    public String cancel() {
        if (!"list".equals(this.from)) {
            return "mainMenu";
        }
        return "cancel";
    }

    public String save() throws Exception {
        Integer originalVersion = this.user.getVersion();
        boolean isNew = "".equals(this.getRequest().getParameter("user.version"));
        if (this.getRequest().isUserInRole("ROLE_ADMIN")) {
            this.user.getRoles().clear();
            String[] userRoles = this.getRequest().getParameterValues("userRoles");
            for (int i = 0; userRoles != null && i < userRoles.length; ++i) {
                String roleName = userRoles[i];
                this.user.addRole(this.roleManager.getRole(roleName));
            }
        }
        try {
            this.userManager.saveUser(this.user);
        }
        catch (AccessDeniedException ade) {
            this.log.warn((Object)ade.getMessage());
            this.getResponse().sendError(403);
            return null;
        }
        catch (UserExistsException e) {
            ArrayList<String> args = new ArrayList<String>();
            args.add(this.user.getUsername());
            args.add(this.user.getEmail());
            this.addActionError(this.getText("errors.existing.user", args));
            this.user.setVersion(originalVersion);
            this.user.setPassword(this.user.getConfirmPassword());
            return "input";
        }
        if (!"list".equals(this.from)) {
            this.saveMessage(this.getText("user.saved"));
            return "mainMenu";
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.user.getFullName());
        if (isNew) {
            this.saveMessage(this.getText("user.added", args));
            this.mailMessage.setSubject(this.getText("signup.email.subject"));
            try {
                this.sendUserMessage(this.user, this.getText("newuser.email.message", args), RequestUtil.getAppURL((HttpServletRequest)this.getRequest()));
            }
            catch (MailException me) {
                this.addActionError(me.getCause().getLocalizedMessage());
            }
            return "success";
        }
        this.saveMessage(this.getText("user.updated.byAdmin", args));
        return "input";
    }

    public String list() {
        this.users = this.userManager.getUsers(new User());
        return "success";
    }
}

