/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.webapp.action;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.appfuse.model.User;
import org.appfuse.webapp.action.BaseAction;
import org.appfuse.webapp.util.RequestUtil;

public class PasswordHintAction
extends BaseAction {
    private static final long serialVersionUID = -4037514607101222025L;
    private String username;

    public void setUsername(String username) {
        this.username = username;
    }

    public String execute() {
        ArrayList<String> args = new ArrayList<String>();
        if (this.username == null) {
            this.log.warn((Object)"Username not specified, notifying user that it's a required field.");
            args.add(this.getText("user.username"));
            this.addActionError(this.getText("errors.requiredField", args));
            return "input";
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Processing Password Hint...");
        }
        try {
            User user = this.userManager.getUserByUsername(this.username);
            String hint = user.getPasswordHint();
            if (hint == null || hint.trim().equals("")) {
                this.log.warn((Object)("User '" + this.username + "' found, but no password hint exists."));
                this.addActionError(this.getText("login.passwordHint.missing"));
                return "input";
            }
            StringBuffer msg = new StringBuffer();
            msg.append("Your password hint is: ").append(hint);
            msg.append("\n\nLogin at: ").append(RequestUtil.getAppURL((HttpServletRequest)this.getRequest()));
            this.mailMessage.setTo(user.getEmail());
            String subject = '[' + this.getText("webapp.name") + "] " + this.getText("user.passwordHint");
            this.mailMessage.setSubject(subject);
            this.mailMessage.setText(msg.toString());
            this.mailEngine.send(this.mailMessage);
            args.add(this.username);
            args.add(user.getEmail());
            this.saveMessage(this.getText("login.passwordHint.sent", args));
        }
        catch (Exception e) {
            this.log.warn((Object)("Username '" + this.username + "' not found in database."));
            args.add(this.username);
            this.addActionError(this.getText("login.passwordHint.error", args));
            return "input";
        }
        return "success";
    }
}

