/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.webapp.action;

import com.opensymphony.xwork2.Preparable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts2.ServletActionContext;
import org.appfuse.dao.SearchException;
import org.appfuse.model.Role;
import org.appfuse.model.User;
import org.appfuse.service.UserExistsException;
import org.appfuse.webapp.action.BaseAction;
import org.appfuse.webapp.util.RequestUtil;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.mail.MailException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class UserAction
extends BaseAction
implements Preparable {
    private static final long serialVersionUID = 6776558938712115191L;
    private List<User> users;
    private User user;
    private String id;
    private String query;

    public void prepare() {
        if (this.getRequest().getMethod().equalsIgnoreCase("post") && !"".equals(this.getRequest().getParameter("user.id"))) {
            this.user = this.userManager.getUser(this.getRequest().getParameter("user.id"));
        }
    }

    public List<User> getUsers() {
        return this.users;
    }

    public void setId(String id) {
        this.id = id;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setQ(String q) {
        this.query = q;
    }

    public String delete() {
        this.userManager.removeUser(this.user.getId().toString());
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.user.getFullName());
        this.saveMessage(this.getText("user.deleted", args));
        return "success";
    }

    public String edit() throws IOException {
        HttpServletRequest request = this.getRequest();
        boolean editProfile = request.getRequestURI().contains("editProfile");
        if (editProfile && (request.getParameter("id") != null || request.getParameter("from") != null)) {
            ServletActionContext.getResponse().sendError(403);
            this.log.warn((Object)("User '" + request.getRemoteUser() + "' is trying to edit user '" + request.getParameter("id") + "'"));
            return null;
        }
        if (this.id != null) {
            this.user = this.userManager.getUser(this.id);
        } else if (editProfile) {
            this.user = this.userManager.getUserByUsername(request.getRemoteUser());
        } else {
            this.user = new User();
            this.user.addRole(new Role("ROLE_USER"));
        }
        if (this.user.getUsername() != null) {
            Authentication auth;
            this.user.setConfirmPassword(this.user.getPassword());
            this.log.debug((Object)"checking for remember me login...");
            AuthenticationTrustResolverImpl resolver = new AuthenticationTrustResolverImpl();
            SecurityContext ctx = SecurityContextHolder.getContext();
            if (ctx != null && resolver.isRememberMe(auth = ctx.getAuthentication())) {
                this.getSession().setAttribute("cookieLogin", (Object)"true");
                this.saveMessage(this.getText("userProfile.cookieLogin"));
            }
        }
        return "success";
    }

    public String execute() {
        return "success";
    }

    public String cancel() {
        if (!"list".equals(this.from)) {
            return "mainMenu";
        }
        return "cancel";
    }

    public String save() throws Exception {
        Integer originalVersion = this.user.getVersion();
        boolean isNew = "".equals(this.getRequest().getParameter("user.version"));
        if (this.getRequest().isUserInRole("ROLE_ADMIN")) {
            this.user.getRoles().clear();
            String[] userRoles = this.getRequest().getParameterValues("userRoles");
            for (int i = 0; userRoles != null && i < userRoles.length; ++i) {
                String roleName = userRoles[i];
                try {
                    this.user.addRole(this.roleManager.getRole(roleName));
                    continue;
                }
                catch (DataIntegrityViolationException e) {
                    return this.showUserExistsException(originalVersion);
                }
            }
        }
        try {
            this.userManager.saveUser(this.user);
        }
        catch (AccessDeniedException ade) {
            this.log.warn((Object)ade.getMessage());
            this.getResponse().sendError(403);
            return null;
        }
        catch (UserExistsException e) {
            return this.showUserExistsException(originalVersion);
        }
        if (!"list".equals(this.from)) {
            this.saveMessage(this.getText("user.saved"));
            return "mainMenu";
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.user.getFullName());
        if (isNew) {
            this.saveMessage(this.getText("user.added", args));
            this.mailMessage.setSubject(this.getText("signup.email.subject"));
            try {
                this.sendUserMessage(this.user, this.getText("newuser.email.message", args), RequestUtil.getAppURL((HttpServletRequest)this.getRequest()));
            }
            catch (MailException me) {
                this.addActionError(me.getCause().getLocalizedMessage());
            }
            return "success";
        }
        this.user.setConfirmPassword(this.user.getPassword());
        this.saveMessage(this.getText("user.updated.byAdmin", args));
        return "input";
    }

    private String showUserExistsException(Integer originalVersion) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.user.getUsername());
        args.add(this.user.getEmail());
        this.addActionError(this.getText("errors.existing.user", args));
        this.user.setVersion(originalVersion);
        this.user.setPassword(this.user.getConfirmPassword());
        return "input";
    }

    public String list() {
        try {
            this.users = this.userManager.search(this.query);
        }
        catch (SearchException se) {
            this.addActionError(se.getMessage());
            this.users = this.userManager.getUsers();
        }
        return "success";
    }
}

