/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.appfuse.WarPathUtils;

public class AddClassesMojo
extends AbstractMojo {
    private File workDirectory;
    private List reactorProjects;
    private MavenProject project;
    private ArtifactFactory artifactFactory;

    public void execute() throws MojoExecutionException {
        File f = this.workDirectory;
        if (!f.exists()) {
            f.mkdirs();
        }
        Set artifacts = this.project.getArtifacts();
        List duplicates = this.findDuplicates(artifacts);
        HashSet<Dependency> newDependencies = new HashSet<Dependency>();
        for (Artifact artifact : artifacts) {
            ScopeArtifactFilter filter = new ScopeArtifactFilter("compile");
            if (!"warpath".equals(artifact.getType()) || !filter.include(artifact) || artifact.isOptional()) continue;
            String warWorkingDir = this.getDefaultFinalName(artifact);
            this.getLog().debug((CharSequence)("Processing war dependency " + warWorkingDir));
            if (duplicates.contains(warWorkingDir)) {
                this.getLog().debug((CharSequence)("Duplicate war dependency found:" + warWorkingDir));
                warWorkingDir = artifact.getGroupId() + "-" + warWorkingDir;
                this.getLog().debug((CharSequence)("Deplicate war dependency renamed to " + warWorkingDir));
            }
            File warClassesDirectory = new File(this.workDirectory, warWorkingDir);
            try {
                WarPathUtils.unpackWarClassesIfNewer(artifact.getFile(), warClassesDirectory);
            }
            catch (IOException e) {
                throw new MojoExecutionException("I/O error while processing WAR dependencies.", (Exception)e);
            }
            this.getLog().debug((CharSequence)("Adding new dependenvy artifact entry for " + warWorkingDir));
            try {
                newDependencies.add(this.getWarClassesDependency(artifact, warClassesDirectory));
            }
            catch (OverConstrainedVersionException e) {
                throw new MojoExecutionException("Failed to created war classes dependency for artifact " + warWorkingDir, (Exception)((Object)e));
            }
        }
        if (newDependencies.size() > 0) {
            this.addDepenciesToProject(this.project, newDependencies);
            for (int i = 0; i < this.reactorProjects.size(); ++i) {
                MavenProject mavenProject = (MavenProject)this.reactorProjects.get(i);
                if (!mavenProject.getArtifactId().equals(this.project.getArtifactId()) || !mavenProject.getGroupId().equals(this.project.getGroupId()) || mavenProject == this.project) continue;
                this.getLog().debug((CharSequence)("Adding dependencies to reactor project: " + mavenProject.getGroupId() + "-" + mavenProject.getArtifactId()));
                this.addDepenciesToProject(mavenProject, newDependencies);
            }
        }
    }

    private void addDepenciesToProject(MavenProject project, Set dependencies) throws MojoExecutionException {
        ArrayList amalgamatedDependencies = new ArrayList();
        amalgamatedDependencies.addAll(dependencies);
        amalgamatedDependencies.addAll(project.getDependencies());
        project.setDependencies(amalgamatedDependencies);
        try {
            project.setDependencyArtifacts(project.createArtifacts(this.artifactFactory, null, null));
        }
        catch (InvalidDependencyVersionException e) {
            throw new MojoExecutionException("Failed to resolve dependency artifacts.", (Exception)((Object)e));
        }
    }

    private Dependency getWarClassesDependency(Artifact artifact, File warClassesDirectory) throws OverConstrainedVersionException {
        Dependency dependency = new Dependency();
        dependency.setArtifactId(artifact.getArtifactId());
        dependency.setGroupId(artifact.getGroupId());
        dependency.setType("classes");
        dependency.setScope("system");
        dependency.setOptional(true);
        dependency.setVersion(artifact.getSelectedVersion().toString());
        dependency.setSystemPath(warClassesDirectory.getPath());
        return dependency;
    }

    private List findDuplicates(Set artifacts) {
        ArrayList<String> duplicates = new ArrayList<String>();
        ArrayList<String> identifiers = new ArrayList<String>();
        for (Artifact artifact : artifacts) {
            String candidate = this.getDefaultFinalName(artifact);
            if (identifiers.contains(candidate)) {
                duplicates.add(candidate);
                continue;
            }
            identifiers.add(candidate);
        }
        return duplicates;
    }

    private String getDefaultFinalName(Artifact artifact) {
        if ("warpath".equals(artifact.getType())) {
            return artifact.getArtifactId() + "-" + artifact.getVersion() + "." + artifact.getType() + ".jar";
        }
        return artifact.getArtifactId() + "-" + artifact.getVersion() + "." + artifact.getArtifactHandler().getExtension();
    }
}

