/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarOutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class WarPathUtils {
    public static final Pattern WEBINF_CLASSES_PATTERN = Pattern.compile("^[/\\\\]?web-inf[/\\\\]classes[/\\\\]?(.*)$", 2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unpackWarClassesIfNewer(File warFile, File classesJarFile) throws IOException {
        boolean process = false;
        if (!classesJarFile.exists() || warFile.lastModified() > classesJarFile.lastModified()) {
            process = true;
        }
        if (process) {
            ZipFile zipFile = new ZipFile(warFile);
            JarOutputStream classesJarOutputStream = new JarOutputStream(new FileOutputStream(classesJarFile));
            try {
                WarPathUtils.unpackWebInfClasses(zipFile, classesJarOutputStream);
            }
            finally {
                WarPathUtils.closeZipFile(zipFile);
                WarPathUtils.closeOutputStream(classesJarOutputStream);
            }
        }
    }

    private static void closeOutputStream(JarOutputStream classesJarOutputStream) {
        if (classesJarOutputStream != null) {
            try {
                classesJarOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void closeZipFile(ZipFile zipFile) {
        if (zipFile != null) {
            try {
                zipFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void unpackWebInfClasses(ZipFile zipFile, JarOutputStream classesJarOutputStream) throws IOException {
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        while (zipEntries.hasMoreElements()) {
            int readLength;
            ZipEntry zipEntry = zipEntries.nextElement();
            Matcher matcher = WEBINF_CLASSES_PATTERN.matcher(zipEntry.getName());
            if (!matcher.matches() || matcher.group(1).length() <= 0) continue;
            String classesEntry = matcher.group(1);
            ZipEntry jarEntry = new ZipEntry(classesEntry);
            jarEntry.setComment(zipEntry.getComment());
            jarEntry.setExtra(zipEntry.getExtra());
            jarEntry.setMethod(zipEntry.getMethod());
            jarEntry.setTime(zipEntry.getTime());
            jarEntry.setSize(zipEntry.getSize());
            jarEntry.setCompressedSize(zipEntry.getCompressedSize());
            jarEntry.setCrc(zipEntry.getCrc());
            classesJarOutputStream.putNextEntry(jarEntry);
            byte[] readBuffer = new byte[1024];
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            while ((readLength = inputStream.read(readBuffer)) >= 0) {
                classesJarOutputStream.write(readBuffer, 0, readLength);
            }
        }
    }
}

