/*
 * Decompiled with CFR 0.152.
 */
package org.applecommander.disassembler.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.applecommander.disassembler.api.Instruction;
import org.applecommander.disassembler.api.InstructionSet;
import org.applecommander.disassembler.api.Program;
import org.applecommander.disassembler.api.mos6502.InstructionSet6502;
import org.ini4j.Ini;
import org.ini4j.Profile;

public class Disassembler {
    private static final Ini ini = new Ini();
    private int startAddress;
    private int bytesToSkip;
    private int bytesToDecode;
    private byte[] code;
    private InstructionSet instructionSet;

    public static Set<String> labelGroups() {
        return ini.keySet();
    }

    public static Builder with(byte[] code) {
        return new Builder(code);
    }

    private List<Instruction> decode(Map<Integer, String> labels) {
        if (this.bytesToSkip > 0 || this.bytesToDecode > 0) {
            byte[] dest = new byte[this.bytesToDecode == 0 ? this.code.length - this.bytesToSkip : this.bytesToDecode];
            System.arraycopy(this.code, this.bytesToSkip, dest, 0, dest.length);
            this.code = dest;
            this.startAddress += this.bytesToSkip;
        }
        Program program = new Program(this.code, this.startAddress);
        List<Instruction> assembly = this.instructionSet.decode(program);
        assembly.forEach(instruction -> instruction.addressRef().flatMap(Instruction.Operand::address).ifPresent(address -> {
            if (address >= this.startAddress && address < this.startAddress + this.code.length) {
                labels.computeIfAbsent((Integer)address, addr -> String.format("L%04X", addr));
            }
        }));
        return assembly;
    }

    public static Optional<Integer> convert(String value) {
        if (value == null) {
            return Optional.empty();
        }
        if (value.startsWith("$")) {
            return Optional.of(Integer.valueOf(value.substring(1), 16));
        }
        if (value.startsWith("0x") || value.startsWith("0X")) {
            return Optional.of(Integer.valueOf(value.substring(2), 16));
        }
        return Optional.of(Integer.valueOf(value));
    }

    static {
        try (InputStream is = Disassembler.class.getResourceAsStream("/addresses.ini");){
            ini.load(is);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static class Builder {
        private final Set<String> sections = new HashSet<String>();
        private final Disassembler disassembler = new Disassembler();

        public Builder(byte[] code) {
            this.disassembler.startAddress = 768;
            this.disassembler.code = code;
            this.disassembler.instructionSet = InstructionSet6502.for6502();
        }

        public List<Instruction> decode() {
            return this.decode(new HashMap<Integer, String>());
        }

        public List<Instruction> decode(Map<Integer, String> labels) {
            assert (labels != null);
            assert (this.disassembler.instructionSet != null);
            for (String name : this.sections) {
                Profile.Section section = (Profile.Section)ini.get((Object)name);
                if (section == null) {
                    throw new RuntimeException(String.format("Section '%s' not defined.", name));
                }
                for (Map.Entry entry : section.entrySet()) {
                    Optional<Integer> address = Disassembler.convert((String)entry.getValue());
                    address.ifPresent(integer -> labels.putIfAbsent((Integer)integer, (String)entry.getKey()));
                }
            }
            return this.disassembler.decode(labels);
        }

        public Builder startingAddress(int address) {
            this.disassembler.startAddress = address;
            return this;
        }

        public Builder bytesToSkip(int skip) {
            this.disassembler.bytesToSkip = skip;
            return this;
        }

        public Builder bytesToDecode(int length) {
            this.disassembler.bytesToDecode = length;
            return this;
        }

        public Builder use(InstructionSet instructionSet) {
            this.disassembler.instructionSet = instructionSet;
            return this;
        }

        public Builder section(List<String> names) {
            if (names != null) {
                this.sections.addAll(names);
            }
            return this;
        }
    }
}

