/*
 * Decompiled with CFR 0.152.
 */
package org.applecommander.disassembler.api;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import org.applecommander.disassembler.api.InstructionSet;
import org.applecommander.disassembler.api.mos6502.InstructionSet6502;
import org.applecommander.disassembler.api.pcode.InstructionSetPCode;
import org.applecommander.disassembler.api.sweet16.InstructionSetSWEET16;
import org.applecommander.disassembler.api.z80.InstructionSetZ80;

public class GenerateMarkdown {
    public static void main(String[] args) throws IOException {
        Map<String, InstructionSetPCode> instructionSets = Map.of("6502", InstructionSet6502.for6502(), "6502X", InstructionSet6502.for6502withIllegalInstructions(), "65C02", InstructionSet6502.for65C02(), "SWEET16", InstructionSetSWEET16.forSWEET16(), "Z80", InstructionSetZ80.forZ80(), "PCODE", InstructionSetPCode.forApplePascal());
        for (Map.Entry<String, InstructionSetPCode> entry : instructionSets.entrySet()) {
            String filename = String.format("docs/%s.md", entry.getKey());
            try (FileOutputStream out = new FileOutputStream(filename);
                 PrintWriter pw = new PrintWriter(out);){
                GenerateMarkdown.createMarkdownTable(pw, ((InstructionSet)entry.getValue()).opcodeTables());
            }
        }
    }

    private static void createMarkdownTable(PrintWriter pw, List<InstructionSet.OpcodeTable> opcodeTables) {
        for (InstructionSet.OpcodeTable opcodeTable : opcodeTables) {
            int x;
            pw.printf("# %s\n", opcodeTable.name());
            pw.print("| |");
            for (x = 0; x < 16; ++x) {
                pw.printf(" _%1X |", x);
            }
            pw.println();
            pw.print("| :--- |");
            for (x = 0; x < 16; ++x) {
                pw.print(" :--- |");
            }
            pw.println();
            for (int y = 0; y < 256; y += 16) {
                pw.printf("| %1X_ |", y >> 4);
                for (int x2 = 0; x2 < 16; ++x2) {
                    String text = opcodeTable.opcodeExample(y | x2);
                    pw.printf(" %s |", text);
                }
                pw.println();
            }
        }
        pw.printf("\n\n(Automatically generated; do not change manually!)\n\n", new Object[0]);
    }
}

