/*
 * Decompiled with CFR 0.152.
 */
package org.applecommander.disassembler.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public record Instruction(int address, byte[] code, String mnemonic, List<Operand> operands, Optional<String> description) {
    public Optional<Operand> addressRef() {
        for (Operand operand : this.operands) {
            if (!operand.address().isPresent()) continue;
            return Optional.of(operand);
        }
        return Optional.empty();
    }

    public static Builder at(int address) {
        return new Builder(address);
    }

    public record Operand(String opFmt, String value, Optional<Integer> address) {
        public String format() {
            return String.format(this.opFmt, this.value);
        }

        public String format(String label) {
            return String.format(this.opFmt, label);
        }
    }

    public static class Builder {
        private final int address;
        private byte[] code = new byte[0];
        private String mnemonic = "";
        private final List<Operand> operands = new ArrayList<Operand>();
        private String description;

        private Builder(int address) {
            this.address = address;
        }

        public int address() {
            return this.address;
        }

        public Builder code(byte[] code) {
            assert (code != null);
            this.code = code;
            return this;
        }

        public Builder mnemonic(String mnemonic) {
            assert (mnemonic != null);
            this.mnemonic = mnemonic;
            return this;
        }

        public String mnemonic() {
            return this.mnemonic;
        }

        public Builder opAddress(String opFmt, String fmt, int address) {
            this.operands.add(new OpBuilder(opFmt).address(fmt, address).get());
            return this;
        }

        public Builder opValue(String fmt, Object ... values) {
            this.operands.add(new OpBuilder("%s").value(fmt, values).get());
            return this;
        }

        public Builder description(String description) {
            assert (description != null);
            this.description = description;
            return this;
        }

        public Optional<Operand> addressRef() {
            for (Operand operand : this.operands) {
                if (!operand.address().isPresent()) continue;
                return Optional.of(operand);
            }
            return Optional.empty();
        }

        public Instruction get() {
            return new Instruction(this.address, this.code, this.mnemonic, this.operands, Optional.ofNullable(this.description));
        }
    }

    public static class OpBuilder {
        private final String opFmt;
        private String value;
        private Integer address;

        private OpBuilder(String opFmt) {
            this.opFmt = opFmt;
        }

        public OpBuilder value(String fmt, Object ... values) {
            this.value = String.format(fmt, values);
            return this;
        }

        public OpBuilder address(String fmt, int address) {
            this.value = String.format(fmt, address);
            this.address = address;
            return this;
        }

        public Optional<Integer> address() {
            return Optional.ofNullable(this.address);
        }

        public Operand get() {
            return new Operand(this.opFmt, this.value, Optional.ofNullable(this.address));
        }
    }
}

