/*
 * Decompiled with CFR 0.152.
 */
package org.applecommander.disassembler.api.mos6502;

public enum AddressMode6502 {
    ACC(1),
    ABS(3),
    ABSX(3),
    ABSY(3),
    IMM(2),
    IMP(1),
    INDABS(3),
    INDABSX(3),
    INDZP(2),
    INDZPX(2),
    INDZPY(2),
    REL(2),
    ZP(2),
    ZPX(2),
    ZPY(2),
    ZZZ1(1),
    ZZZ2(2),
    ZZZ3(3);

    private final int instructionLength;
    public static final AddressMode6502[] MOS6502;
    public static final AddressMode6502[] WDC65C02;

    private AddressMode6502(int instructionLength) {
        this.instructionLength = instructionLength;
    }

    public int getInstructionLength() {
        return this.instructionLength;
    }

    public boolean isOperandAbsoluteAddress() {
        return this.in(ABS, ABSX, ABSY, INDABS, INDABSX);
    }

    public boolean isOperandRelativeAddress() {
        return this.in(REL);
    }

    private boolean in(AddressMode6502 ... addressModes) {
        for (AddressMode6502 am : addressModes) {
            if (this != am) continue;
            return true;
        }
        return false;
    }

    static {
        MOS6502 = new AddressMode6502[]{IMP, INDZPX, IMP, INDZPX, ZP, ZP, ZP, ZP, IMP, IMM, ACC, IMM, ABS, ABS, ABS, ABS, REL, INDZPY, IMP, INDZPY, ZPX, ZPX, ZPX, ZPX, IMP, ABSY, IMP, ABSY, ABSX, ABSX, ABSX, ABSX, ABS, INDZPX, IMP, INDZPX, ZP, ZP, ZP, ZP, IMP, IMM, ACC, IMM, ABS, ABS, ABS, ABS, REL, INDZPY, IMP, INDZPY, ZPX, ZPX, ZPX, ZPX, IMP, ABSY, IMP, ABSY, ABSX, ABSX, ABSX, ABSX, IMP, INDZPX, IMP, INDZPX, ZP, ZP, ZP, ZP, IMP, IMM, ACC, IMM, ABS, ABS, ABS, ABS, REL, INDZPY, IMP, INDZPY, ZPX, ZPX, ZPX, ZPX, IMP, ABSY, IMP, ABSY, ABSX, ABSX, ABSX, ABSX, IMP, INDZPX, IMP, INDZPX, ZP, ZP, ZP, ZP, IMP, IMM, ACC, IMM, INDABS, ABS, ABS, ABS, REL, INDZPY, IMP, INDZPY, ZPX, ZPX, ZPX, ZPX, IMP, ABSY, IMP, ABSY, ABSX, ABSX, ABSX, ABSX, IMM, INDZPX, IMM, INDZPX, ZP, ZP, ZP, ZP, IMP, IMM, IMP, IMM, ABS, ABS, ABS, ABS, REL, INDZPY, IMP, INDZPY, ZPX, ZPX, ZPY, ZPY, IMP, ABSY, IMP, ABSY, ABSX, ABSX, ABSY, ABSY, IMM, INDZPX, IMM, INDZPX, ZP, ZP, ZP, ZP, IMP, IMM, IMP, IMM, ABS, ABS, ABS, ABS, REL, INDZPY, IMP, INDZPY, ZPX, ZPX, ZPY, ZPY, IMP, ABSY, IMP, ABSY, ABSX, ABSX, ABSY, ABSY, IMM, INDZPX, IMM, INDZPX, ZP, ZP, ZP, ZP, IMP, IMM, IMP, IMM, ABS, ABS, ABS, ABS, REL, INDZPY, IMP, INDZPY, ZPX, ZPX, ZPX, ZPX, IMP, ABSY, IMP, ABSY, ABSX, ABSX, ABSX, ABSX, IMM, INDZPX, IMM, INDZPX, ZP, ZP, ZP, ZP, IMP, IMM, IMP, IMM, ABS, ABS, ABS, ABS, REL, INDZPY, IMP, INDZPY, ZPX, ZPX, ZPX, ZPX, IMP, ABSY, IMP, ABSY, ABSX, ABSX, ABSX, ABSX};
        WDC65C02 = new AddressMode6502[]{IMP, INDZPX, ZZZ2, ZZZ1, ZP, ZP, ZP, ZP, IMP, IMM, ACC, ZZZ1, ABS, ABS, ABS, REL, REL, INDZPY, INDZP, ZZZ1, ZP, ZPX, ZPX, ZP, IMP, ABSY, ACC, ZZZ1, ABS, ABSX, ABSX, REL, ABS, INDZPX, ZZZ2, ZZZ1, ZP, ZP, ZP, ZP, IMP, IMM, ACC, ZZZ1, ABS, ABS, ABS, REL, REL, INDZPY, INDZP, ZZZ1, ZPX, ZPX, ZPX, ZP, IMP, ABSY, ACC, ZZZ1, ABSX, ABSX, ABSX, REL, IMP, INDZPX, ZZZ2, ZZZ1, ZZZ2, ZP, ZP, ZP, IMP, IMM, ACC, ZZZ1, ABS, ABS, ABS, REL, REL, INDZPY, INDZP, ZZZ1, ZZZ2, ZPX, ZPX, ZP, IMP, ABSY, IMP, ZZZ1, ZZZ3, ABSX, ABSX, REL, IMP, INDZPX, ZZZ2, ZZZ1, ZP, ZP, ZP, ZP, IMP, IMM, ACC, ZZZ1, INDABS, ABS, ABS, REL, REL, INDZPY, INDZP, ZZZ1, ZPX, ZPX, ZPX, ZP, IMP, ABSY, IMP, ZZZ1, INDABSX, ABSX, ABSX, REL, REL, INDZPX, ZZZ2, ZZZ1, ZP, ZP, ZP, ZP, IMP, IMM, IMP, ZZZ1, ABS, ABS, ABS, REL, REL, INDZPY, INDZP, ZZZ1, ZPX, ZPX, ZPY, ZP, IMP, ABSY, IMP, ZZZ1, ABS, ABSX, ABSX, REL, IMM, INDZPX, IMM, ZZZ1, ZP, ZP, ZP, ZP, IMP, IMM, IMP, ZZZ1, ABS, ABS, ABS, REL, REL, INDZPY, INDZP, ZZZ1, ZPX, ZPX, ZPY, ZP, IMP, ABSY, IMP, ZZZ1, ABSX, ABSX, ABSY, REL, IMM, INDZPX, ZZZ2, ZZZ1, ZP, ZP, ZP, ZP, IMP, IMM, IMP, IMM, ABS, ABS, ABS, REL, REL, INDZPY, INDZP, ZZZ1, ZZZ2, ZPX, ZPX, ZP, IMP, ABSY, IMP, ABSY, ZZZ3, ABSX, ABSX, REL, IMM, INDZPX, ZZZ2, ZZZ1, ZP, ZP, ZP, ZP, IMP, IMM, IMP, ZZZ1, ABS, ABS, ABS, REL, REL, INDZPY, INDZP, ZZZ1, ZZZ2, ZPX, ZPX, ZP, IMP, ABSY, IMP, ZZZ1, ZZZ3, ABSX, ABSX, REL};
    }
}

