/*
 * Decompiled with CFR 0.152.
 */
package org.applecommander.disassembler.api.pcode;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.applecommander.disassembler.api.Disassembler;
import org.applecommander.disassembler.api.Instruction;
import org.applecommander.disassembler.api.InstructionSet;
import org.applecommander.disassembler.api.Program;
import org.ini4j.Ini;
import org.ini4j.Profile;

public class InstructionSetPCode
implements InstructionSet {
    private static final Profile.Section DESCRIPTIONS;
    private static final Map<Integer, String> CSP_MAP;
    private static final String[] TYPE_NAMES;
    private static final Opcode[] OPCODES;

    public static InstructionSetPCode forApplePascal() {
        return new InstructionSetPCode();
    }

    private InstructionSetPCode() {
    }

    @Override
    public InstructionSet.Defaults defaults() {
        return InstructionSet.Defaults.builder().startAddress(0).bytesPerInstruction(8).includeDescription(true).get();
    }

    @Override
    public List<Instruction> decode(Program program) {
        ArrayList<Instruction> assembly = new ArrayList<Instruction>();
        Procedure procedure = new Procedure(program);
        while (procedure.hasMore()) {
            if (procedure.currentOffset() >= procedure.jumpTable()) {
                assembly.add(Instruction.at(procedure.currentAddress()).mnemonic("J/T").opAddress("%s", "$%04X", procedure.readSelfRelativeW()).code(procedure.bytesRead()).get());
                continue;
            }
            Opcode opcode = OPCODES[procedure.readUB()];
            Instruction.Builder builder = Instruction.at(procedure.currentAddress());
            builder.mnemonic(opcode.mnemonic);
            block12: for (Flag flag : opcode.flags) {
                switch (flag.ordinal()) {
                    case 0: 
                    case 2: {
                        builder.opValue("%d", procedure.readUB());
                        break;
                    }
                    case 1: {
                        builder.opAddress("%s", "$%04X", procedure.readSBOffset());
                        break;
                    }
                    case 3: {
                        builder.opValue("%d", procedure.readB());
                        break;
                    }
                    case 4: {
                        builder.opValue("%d", procedure.readW());
                        break;
                    }
                    case 5: {
                        int t = procedure.readUB();
                        builder.mnemonic(String.format("%s%s", opcode.mnemonic, TYPE_NAMES[t]));
                        if (t != 10 && t != 12) continue block12;
                        builder.opValue("%d", procedure.readB());
                        break;
                    }
                    case 6: {
                        int csp = procedure.readUB();
                        if (CSP_MAP.containsKey(csp)) {
                            builder.mnemonic(CSP_MAP.get(csp));
                            break;
                        }
                        builder.opValue("%d", csp);
                        break;
                    }
                    case 7: {
                        int ub = procedure.readUB();
                        procedure.alignToWord();
                        for (int i = 0; i < ub; ++i) {
                            builder.opValue("%d", procedure.readW());
                        }
                        continue block12;
                    }
                    case 8: 
                    case 9: {
                        int ub = procedure.readUB();
                        StringBuilder sb = new StringBuilder();
                        for (int i = 0; i < ub; ++i) {
                            sb.append((char)procedure.readUB());
                        }
                        builder.opValue("'%s'", sb.toString());
                        break;
                    }
                    case 10: {
                        boolean aligned = procedure.alignToWord();
                        int w1 = procedure.readW();
                        int w2 = procedure.readW();
                        builder.opValue("Range %d..%d", w1, w2);
                        procedure.readUB();
                        int w3addr = procedure.readSBOffset() + 5;
                        if (aligned) {
                            ++w3addr;
                        }
                        builder.opValue("UJP $%04X", w3addr);
                        for (int i = w1; i <= w2; ++i) {
                            builder.opAddress("%s", "$%04X", procedure.readSelfRelativeW());
                        }
                        continue block12;
                    }
                    default: {
                        throw new RuntimeException("Unexpected flag type: " + String.valueOf((Object)flag));
                    }
                }
            }
            opcode.impliedValue.ifPresent(n -> builder.opValue("%d", n));
            if (DESCRIPTIONS.containsKey((Object)builder.mnemonic())) {
                builder.description((String)DESCRIPTIONS.get((Object)builder.mnemonic()));
            }
            builder.code(procedure.bytesRead());
            assembly.add(builder.get());
        }
        return assembly;
    }

    @Override
    public List<InstructionSet.OpcodeTable> opcodeTables() {
        return List.of(new OpcodeTablePCode());
    }

    static void opcodeRange(int firstValue, String mnemonic, int firstOpcode, int lastOpcode) {
        for (int opcode = firstOpcode; opcode <= lastOpcode; ++opcode) {
            assert (OPCODES[opcode] == null);
            InstructionSetPCode.OPCODES[opcode] = new Opcode(opcode, mnemonic, Optional.of(opcode - firstOpcode + firstValue), List.of());
        }
    }

    static void opcode(int opcode, String mnemonic, Flag ... flags) {
        assert (OPCODES[opcode] == null);
        InstructionSetPCode.OPCODES[opcode] = new Opcode(opcode, mnemonic, Optional.empty(), List.of(flags));
    }

    static {
        try (InputStream is = Disassembler.class.getResourceAsStream("/instructions.ini");){
            Ini ini = new Ini();
            ini.load(is);
            DESCRIPTIONS = (Profile.Section)ini.get((Object)"pcode");
            assert (DESCRIPTIONS != null);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        CSP_MAP = Map.ofEntries(Map.entry(0, "IOC"), Map.entry(1, "NEW"), Map.entry(2, "MVL"), Map.entry(3, "MVR"), Map.entry(4, "EXIT"), Map.entry(5, "UREAD"), Map.entry(6, "UWRT"), Map.entry(7, "IDS"), Map.entry(8, "TRS"), Map.entry(9, "TIM"), Map.entry(10, "FLC"), Map.entry(11, "SCN"), Map.entry(12, "USTAT"), Map.entry(20, "LDS"), Map.entry(21, "ULS"), Map.entry(22, "TNC"), Map.entry(23, "RND"), Map.entry(31, "MRK"), Map.entry(32, "RLS"), Map.entry(33, "IOR"), Map.entry(34, "UBUSY"), Map.entry(35, "POT"), Map.entry(36, "UWAIT"), Map.entry(37, "UCLR"), Map.entry(38, "HLT"), Map.entry(39, "MEMAV"));
        TYPE_NAMES = new String[]{"", "", "REAL", "", "STR", "", "BOOL", "", "POWR", "", "BYT", "", "WORD"};
        OPCODES = new Opcode[256];
        InstructionSetPCode.opcodeRange(0, "SLDC", 0, 127);
        InstructionSetPCode.opcode(128, "ABI", new Flag[0]);
        InstructionSetPCode.opcode(129, "ABR", new Flag[0]);
        InstructionSetPCode.opcode(130, "ADI", new Flag[0]);
        InstructionSetPCode.opcode(131, "ADR", new Flag[0]);
        InstructionSetPCode.opcode(132, "LAND", new Flag[0]);
        InstructionSetPCode.opcode(133, "DIF", new Flag[0]);
        InstructionSetPCode.opcode(134, "DVI", new Flag[0]);
        InstructionSetPCode.opcode(135, "DVR", new Flag[0]);
        InstructionSetPCode.opcode(136, "CHK", new Flag[0]);
        InstructionSetPCode.opcode(137, "FLO", new Flag[0]);
        InstructionSetPCode.opcode(138, "FLT", new Flag[0]);
        InstructionSetPCode.opcode(139, "INN", new Flag[0]);
        InstructionSetPCode.opcode(140, "INT", new Flag[0]);
        InstructionSetPCode.opcode(141, "LOR", new Flag[0]);
        InstructionSetPCode.opcode(142, "MODI", new Flag[0]);
        InstructionSetPCode.opcode(143, "MPI", new Flag[0]);
        InstructionSetPCode.opcode(144, "MPR", new Flag[0]);
        InstructionSetPCode.opcode(145, "NGI", new Flag[0]);
        InstructionSetPCode.opcode(146, "NGR", new Flag[0]);
        InstructionSetPCode.opcode(147, "LNOT", new Flag[0]);
        InstructionSetPCode.opcode(148, "SRS", new Flag[0]);
        InstructionSetPCode.opcode(149, "SBI", new Flag[0]);
        InstructionSetPCode.opcode(150, "SBR", new Flag[0]);
        InstructionSetPCode.opcode(151, "SGS", new Flag[0]);
        InstructionSetPCode.opcode(152, "SQI", new Flag[0]);
        InstructionSetPCode.opcode(153, "SQR", new Flag[0]);
        InstructionSetPCode.opcode(154, "STO", new Flag[0]);
        InstructionSetPCode.opcode(155, "IXS", new Flag[0]);
        InstructionSetPCode.opcode(156, "UNI", new Flag[0]);
        InstructionSetPCode.opcode(157, "LDE", Flag.UB, Flag.B);
        InstructionSetPCode.opcode(158, "CSP", Flag.CSP);
        InstructionSetPCode.opcode(159, "LDCN", new Flag[0]);
        InstructionSetPCode.opcode(160, "ADJ", Flag.UB);
        InstructionSetPCode.opcode(161, "FJP", Flag.SB);
        InstructionSetPCode.opcode(162, "INC", Flag.B);
        InstructionSetPCode.opcode(163, "IND", Flag.B);
        InstructionSetPCode.opcode(164, "IXA", Flag.B);
        InstructionSetPCode.opcode(165, "LAO", Flag.B);
        InstructionSetPCode.opcode(166, "LSA", Flag.LSA);
        InstructionSetPCode.opcode(167, "LAE", Flag.UB, Flag.B);
        InstructionSetPCode.opcode(168, "MOV", Flag.B);
        InstructionSetPCode.opcode(169, "LDO", Flag.B);
        InstructionSetPCode.opcode(170, "SAS", Flag.UB);
        InstructionSetPCode.opcode(171, "SRO", Flag.B);
        InstructionSetPCode.opcode(172, "XJP", Flag.XJP);
        InstructionSetPCode.opcode(173, "RNP", Flag.DB);
        InstructionSetPCode.opcode(174, "CIP", Flag.UB);
        InstructionSetPCode.opcode(175, "EQU", Flag.TYPE);
        InstructionSetPCode.opcode(176, "GEQ", Flag.TYPE);
        InstructionSetPCode.opcode(177, "GRT", Flag.TYPE);
        InstructionSetPCode.opcode(178, "LDA", Flag.DB, Flag.B);
        InstructionSetPCode.opcode(179, "LDC", Flag.LDC);
        InstructionSetPCode.opcode(180, "LEQ", Flag.TYPE);
        InstructionSetPCode.opcode(181, "LES", Flag.TYPE);
        InstructionSetPCode.opcode(183, "NEQ", Flag.TYPE);
        InstructionSetPCode.opcode(182, "LOD", Flag.DB, Flag.B);
        InstructionSetPCode.opcode(184, "STR", Flag.DB, Flag.B);
        InstructionSetPCode.opcode(185, "UJP", Flag.SB);
        InstructionSetPCode.opcode(186, "LDP", new Flag[0]);
        InstructionSetPCode.opcode(187, "STP", new Flag[0]);
        InstructionSetPCode.opcode(188, "LDM", Flag.UB);
        InstructionSetPCode.opcode(189, "STM", Flag.UB);
        InstructionSetPCode.opcode(190, "LDB", new Flag[0]);
        InstructionSetPCode.opcode(191, "STB", new Flag[0]);
        InstructionSetPCode.opcode(192, "IXP", Flag.UB, Flag.UB);
        InstructionSetPCode.opcode(193, "RBP", Flag.DB);
        InstructionSetPCode.opcode(194, "CBP", Flag.UB);
        InstructionSetPCode.opcode(195, "EQUI", new Flag[0]);
        InstructionSetPCode.opcode(196, "GEQI", new Flag[0]);
        InstructionSetPCode.opcode(197, "GRTI", new Flag[0]);
        InstructionSetPCode.opcode(198, "LLA", Flag.B);
        InstructionSetPCode.opcode(199, "LDCI", Flag.W);
        InstructionSetPCode.opcode(200, "LEQI", new Flag[0]);
        InstructionSetPCode.opcode(201, "LESI", new Flag[0]);
        InstructionSetPCode.opcode(202, "LDL", Flag.B);
        InstructionSetPCode.opcode(203, "NEQI", new Flag[0]);
        InstructionSetPCode.opcode(204, "STL", Flag.B);
        InstructionSetPCode.opcode(205, "CXP", Flag.UB, Flag.UB);
        InstructionSetPCode.opcode(206, "CLP", Flag.UB);
        InstructionSetPCode.opcode(207, "CGP", Flag.UB);
        InstructionSetPCode.opcode(208, "LPA", Flag.LPA);
        InstructionSetPCode.opcode(209, "STE", Flag.UB, Flag.B);
        InstructionSetPCode.opcode(211, "EFJ", Flag.SB);
        InstructionSetPCode.opcode(212, "NFJ", Flag.SB);
        InstructionSetPCode.opcode(213, "BPT", Flag.B);
        InstructionSetPCode.opcode(214, "XIT", new Flag[0]);
        InstructionSetPCode.opcode(215, "NOP", new Flag[0]);
        InstructionSetPCode.opcodeRange(1, "SLDL", 216, 231);
        InstructionSetPCode.opcodeRange(1, "SLDO", 232, 247);
        InstructionSetPCode.opcodeRange(0, "SIND", 248, 255);
    }

    private static class Procedure {
        private final Program program;
        private int length;
        private int jumpTable;

        public Procedure(Program program) {
            this.program = program;
        }

        public boolean hasMore() {
            return this.program.hasMore();
        }

        public int jumpTable() {
            return this.program.length() + this.jumpTable + 8;
        }

        public boolean alignToWord() {
            if ((this.program.currentAddress() + this.length & 1) == 1) {
                ++this.length;
                return true;
            }
            return false;
        }

        public int currentOffset() {
            return this.program.currentOffset();
        }

        public int currentAddress() {
            return this.program.currentAddress();
        }

        public byte[] bytesRead() {
            try {
                byte[] byArray = this.program.read(this.length);
                return byArray;
            }
            finally {
                this.length = 0;
            }
        }

        public int readUB() {
            return this.program.peekUnsignedByte(this.length++);
        }

        public int readSBOffset() {
            int sb;
            if ((sb = this.program.peekSignedByte(this.length++)) < 0) {
                this.jumpTable = Math.min(this.jumpTable, sb);
                int offset = this.program.length() + sb + 8;
                int w = this.program.getUnsignedByte(offset) | this.program.getUnsignedByte(offset + 1) << 8;
                return this.program.baseAddress() + offset - w;
            }
            return this.program.currentAddress() + sb + 2;
        }

        public int readW() {
            return this.readUB() | this.readUB() << 8;
        }

        public int readSelfRelativeW() {
            return this.program.currentAddress() + this.length - this.readW();
        }

        public int readB() {
            int b = this.readUB();
            if (b > 127) {
                b = (b & 0x7F) << 8 | this.readUB();
            }
            return b;
        }
    }

    private record Opcode(int opcode, String mnemonic, Optional<Integer> impliedValue, List<Flag> flags) {
    }

    static enum Flag {
        UB,
        SB,
        DB,
        B,
        W,
        TYPE,
        CSP,
        LDC,
        LPA,
        LSA,
        XJP;

    }

    private static class OpcodeTablePCode
    implements InstructionSet.OpcodeTable {
        private OpcodeTablePCode() {
        }

        @Override
        public String name() {
            return "p-code";
        }

        @Override
        public String opcodeExample(int opcode) {
            Opcode op = OPCODES[opcode];
            if (op == null) {
                return "-";
            }
            return op.impliedValue.map(integer -> String.format("%s %d", op.mnemonic, integer)).orElseGet(() -> op.mnemonic);
        }
    }
}

