/*
 * Decompiled with CFR 0.152.
 */
package org.applecommander.disassembler.api.sweet16;

import java.util.ArrayList;
import java.util.List;
import org.applecommander.disassembler.api.Instruction;
import org.applecommander.disassembler.api.InstructionSet;
import org.applecommander.disassembler.api.Program;
import org.applecommander.disassembler.api.sweet16.AddressModeSWEET16;
import org.applecommander.disassembler.api.sweet16.OpcodeSWEET16;

public class InstructionSetSWEET16
implements InstructionSet {
    public static InstructionSetSWEET16 forSWEET16() {
        return new InstructionSetSWEET16();
    }

    private InstructionSetSWEET16() {
    }

    @Override
    public InstructionSet.Defaults defaults() {
        return InstructionSet.Defaults.builder().startAddress(768).libraryLabels("All").bytesPerInstruction(3).get();
    }

    @Override
    public List<Instruction> decode(Program program) {
        ArrayList<Instruction> assembly = new ArrayList<Instruction>();
        while (program.hasMore()) {
            assembly.add(this.decodeOne(program));
        }
        return assembly;
    }

    public Instruction decodeOne(Program program) {
        AddressModeSWEET16 addressMode;
        OpcodeSWEET16 opcode;
        int op = program.peekUnsignedByte();
        int low = op & 0xF;
        int high = (op & 0xF0) >> 4;
        if (high == 0) {
            opcode = OpcodeSWEET16.NON_REGISTER_OPS[low];
            addressMode = AddressModeSWEET16.NON_REGISTER_OPS[low];
        } else {
            opcode = OpcodeSWEET16.REGISTER_OPS[high];
            addressMode = AddressModeSWEET16.REGISTER_OPS[high];
        }
        if (opcode == OpcodeSWEET16.ZZZ) {
            addressMode = AddressModeSWEET16.IMP;
        }
        int currentAddress = program.currentAddress();
        int value = switch (addressMode.getInstructionLength()) {
            case 3 -> program.peekUnsignedShort(1);
            case 2 -> {
                if (addressMode.isOperandRelativeAddress()) {
                    yield currentAddress + 2 + program.peekSignedByte(1) & 0xFFFF;
                }
                yield program.peekUnsignedByte(1);
            }
            default -> 0;
        };
        Instruction.Builder builder = Instruction.at(currentAddress).code(program.read(addressMode.getInstructionLength())).mnemonic(opcode.getMnemonic());
        switch (addressMode) {
            case CON: {
                builder.opValue("R%d", low).opValue("#$%04X", value);
                break;
            }
            case DIR: {
                builder.opValue("R%d", low);
                break;
            }
            case IND: {
                builder.opValue("@R%d", low);
                break;
            }
            case BRA: {
                builder.opAddress("%s", "$%04X", value);
                break;
            }
        }
        return builder.get();
    }

    @Override
    public List<InstructionSet.OpcodeTable> opcodeTables() {
        return List.of(new OpcodeTableSWEET16());
    }

    private static class OpcodeTableSWEET16
    implements InstructionSet.OpcodeTable {
        private OpcodeTableSWEET16() {
        }

        @Override
        public String name() {
            return "SWEET16";
        }

        @Override
        public String opcodeExample(int op) {
            AddressModeSWEET16 addressMode;
            OpcodeSWEET16 opcode;
            int low = op & 0xF;
            int high = (op & 0xF0) >> 4;
            if (high == 0) {
                opcode = OpcodeSWEET16.NON_REGISTER_OPS[low];
                addressMode = AddressModeSWEET16.NON_REGISTER_OPS[low];
            } else {
                opcode = OpcodeSWEET16.REGISTER_OPS[high];
                addressMode = AddressModeSWEET16.REGISTER_OPS[high];
            }
            if (opcode == OpcodeSWEET16.ZZZ) {
                addressMode = AddressModeSWEET16.IMP;
            }
            String string = opcode.getMnemonic();
            return string + (switch (addressMode) {
                default -> throw new MatchException(null, null);
                case AddressModeSWEET16.CON -> String.format(" R%X,#VALUE", low);
                case AddressModeSWEET16.BRA -> " ADDR";
                case AddressModeSWEET16.DIR -> String.format(" R%X", low);
                case AddressModeSWEET16.IND -> String.format(" @R%X", low);
                case AddressModeSWEET16.IMP -> "";
            });
        }
    }
}

