/*
 * Decompiled with CFR 0.152.
 */
package org.applecommander.disassembler.api.switching6502;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.function.Function;
import org.applecommander.disassembler.api.Instruction;
import org.applecommander.disassembler.api.InstructionSet;
import org.applecommander.disassembler.api.Program;
import org.applecommander.disassembler.api.mos6502.InstructionSet6502;
import org.applecommander.disassembler.api.sweet16.InstructionSetSWEET16;

public class InstructionSet6502Switching
implements InstructionSet {
    private final InstructionSet6502 mos6502;
    private final InstructionSetSWEET16 sweet16;
    private Function<Program, Instruction> strategy = this::decode6502;
    private final Queue<Instruction> pending = new LinkedList<Instruction>();

    public static InstructionSet withSwitching() {
        return new InstructionSet6502Switching(InstructionSet6502.for6502(), InstructionSetSWEET16.forSWEET16());
    }

    private InstructionSet6502Switching(InstructionSet6502 mos6502, InstructionSetSWEET16 sweet16) {
        this.mos6502 = mos6502;
        this.sweet16 = sweet16;
    }

    @Override
    public InstructionSet.Defaults defaults() {
        return InstructionSet.Defaults.builder().startAddress(768).libraryLabels("All").bytesPerInstruction(3).get();
    }

    @Override
    public List<Instruction> decode(Program program) {
        ArrayList<Instruction> assembly = new ArrayList<Instruction>();
        while (program.hasMore()) {
            if (!this.pending.isEmpty()) {
                assembly.add(this.pending.remove());
            }
            assembly.add(this.strategy.apply(program));
        }
        return assembly;
    }

    @Override
    public List<InstructionSet.OpcodeTable> opcodeTables() {
        throw new RuntimeException("Not implemented");
    }

    Instruction decode6502(Program program) {
        Instruction instruction = this.mos6502.decodeOne(program);
        int operandAddress = instruction.addressRef().flatMap(Instruction.Operand::address).orElse(0);
        if ("JSR".equals(instruction.mnemonic()) && operandAddress == 63113) {
            this.strategy = this::decodeSWEET16;
            this.pending.add(Instruction.at(program.currentAddress()).mnemonic(".SWEET16").get());
        }
        return instruction;
    }

    Instruction decodeSWEET16(Program program) {
        Instruction instruction = this.sweet16.decodeOne(program);
        if ("RTN".equals(instruction.mnemonic())) {
            this.strategy = this::decode6502;
            this.pending.add(Instruction.at(program.currentAddress()).mnemonic(".6502").get());
        }
        return instruction;
    }
}

