/*
 * Decompiled with CFR 0.152.
 */
package org.applecommander.disassembler.api.z80;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.applecommander.disassembler.api.Instruction;
import org.applecommander.disassembler.api.InstructionSet;
import org.applecommander.disassembler.api.Program;

public class InstructionSetZ80
implements InstructionSet {
    private static final Opcode[] ROOT_OPCODES = new Opcode[256];
    private static final Opcode[] ED_OPCODES = new Opcode[256];
    private static final Opcode[] CB_OPCODES = new Opcode[256];

    public static InstructionSetZ80 forZ80() {
        return new InstructionSetZ80();
    }

    private InstructionSetZ80() {
    }

    @Override
    public InstructionSet.Defaults defaults() {
        return InstructionSet.Defaults.builder().startAddress(256).bytesPerInstruction(5).get();
    }

    @Override
    public List<Instruction> decode(Program program) {
        ArrayList<Instruction> assembly = new ArrayList<Instruction>();
        while (program.hasMore()) {
            int addr = program.currentAddress();
            Instruction.Builder builder = Instruction.at(addr);
            int length = 1;
            int b = program.peekUnsignedByte();
            Opcode op = ROOT_OPCODES[b];
            boolean ix = false;
            boolean iy = false;
            boolean hasDisplacement = false;
            if (op.flags.contains((Object)Flag.OVERRIDE)) {
                ix = op.opcode == 221;
                iy = op.opcode == 253;
                b = program.peekUnsignedByte(length);
                op = ROOT_OPCODES[b];
                ++length;
            }
            if (ix | iy && (b == 54 || b == 203)) {
                hasDisplacement = true;
                ++length;
            }
            if (op.flags.contains((Object)Flag.PREFIX)) {
                b = program.peekUnsignedByte(length);
                if (op.opcode() == 237) {
                    op = ED_OPCODES[b];
                } else if (op.opcode() == 203) {
                    op = CB_OPCODES[b];
                }
                ++length;
            }
            builder.mnemonic(op.mnemonic);
            int operandValue = 0;
            if (op.flags.contains((Object)Flag.DATLO) && op.flags.contains((Object)Flag.DATHI) || op.flags.contains((Object)Flag.ADDLO) && op.flags.contains((Object)Flag.ADDHI)) {
                int b1 = program.peekUnsignedByte(length);
                int b2 = program.peekUnsignedByte(length + 1);
                operandValue = b1 | b2 << 8;
                length += 2;
            }
            if (op.flags.contains((Object)Flag.DATA) || op.flags.contains((Object)Flag.PORT)) {
                operandValue = program.peekUnsignedByte(length);
                ++length;
            }
            if (op.flags.contains((Object)Flag.OFFSET)) {
                operandValue = addr + program.peekUnsignedByte(length) + 2;
                ++length;
            }
            for (String operandFmt : op.fmts) {
                if (ix || iy) {
                    String reg;
                    String string = reg = ix ? "IX" : "IY";
                    if (operandFmt.contains("(HL)") && hasDisplacement) {
                        displacement = program.peekUnsignedByte(2);
                        operandFmt = operandFmt.replace("(HL)", String.format("(%s+%02XH)", reg, displacement));
                    } else if (operandFmt.contains("(HL)") && b == 233) {
                        operandFmt = operandFmt.replace("(HL)", String.format("(%s)", reg));
                    } else if (operandFmt.contains("(HL)")) {
                        displacement = program.peekUnsignedByte(length);
                        operandFmt = operandFmt.replace("(HL)", String.format("(%s+%02XH)", reg, displacement));
                        ++length;
                    } else if (operandFmt.contains("HL")) {
                        operandFmt = operandFmt.replace("HL", reg);
                    }
                }
                if (operandFmt.contains("data") && op.flags.contains((Object)Flag.DATLO)) {
                    builder.opValue(operandFmt.replace("data", "%04XH"), operandValue);
                    continue;
                }
                if (operandFmt.contains("add")) {
                    builder.opAddress(operandFmt.replace("add", "%s"), "%04XH", operandValue);
                    continue;
                }
                if (operandFmt.contains("port")) {
                    builder.opValue(operandFmt.replace("port", "%02XH"), operandValue);
                    continue;
                }
                if (operandFmt.contains("data") && op.flags.contains((Object)Flag.DATA)) {
                    builder.opValue(operandFmt.replace("data", "%02XH"), operandValue);
                    continue;
                }
                if (operandFmt.contains("offset")) {
                    builder.opAddress(operandFmt.replace("offset", "%s"), "%04XH", operandValue);
                    continue;
                }
                if (operandFmt.isEmpty()) continue;
                builder.opValue(operandFmt, new Object[0]);
            }
            builder.code(program.read(length));
            assembly.add(builder.get());
        }
        return assembly;
    }

    @Override
    public List<InstructionSet.OpcodeTable> opcodeTables() {
        return List.of(new OpcodeTableZ80("Z80 Opcodes", ROOT_OPCODES), new OpcodeTableZ80("'ED' Opcodes", ED_OPCODES), new OpcodeTableZ80("'CB' Opcodes", CB_OPCODES));
    }

    private static Builder with(Opcode[] o) {
        return new Builder(o);
    }

    static {
        InstructionSetZ80.with(ROOT_OPCODES).add(0, "NOP").add(1, "LD", "rp,data", Flag.RP2SP, Flag.DATLO, Flag.DATHI).add(2, "LD", "(rp),A", Flag.RP1).add(3, "INC", "rp", Flag.RP2SP).add(4, "INC", "ddd", Flag.DDD).add(5, "DEC", "ddd", Flag.DDD).add(6, "LD", "ddd,data", Flag.DDD, Flag.DATA).add(7, "RLCA").add(9, "ADD", "HL,rp", Flag.RP2SP).add(10, "LD", "A,(rp)", Flag.RP1).add(11, "DEC", "rp", Flag.RP2SP).add(8, "EX", "AF,AF'", new Flag[0]).add(15, "RRCA").add(16, "DJNZ", "offset", Flag.OFFSET).add(23, "RLA").add(24, "JR", "offset", Flag.OFFSET).add(31, "RRA").add(32, "JR", "cc,offset", Flag.CC2, Flag.OFFSET).add(34, "LD", "(add),HL", Flag.ADDLO, Flag.ADDHI).add(39, "DAA").add(42, "LD", "HL,(add)", Flag.ADDLO, Flag.ADDHI).add(47, "CPL").add(50, "LD", "(add),A", Flag.ADDLO, Flag.ADDHI).add(55, "SCF").add(58, "LD", "A,(add)", Flag.ADDLO, Flag.ADDHI).add(63, "CCF").add(64, "LD", "ddd,sss", Flag.DDD, Flag.SSS).add(118, "HALT").add(128, "ADD,ADC,SUB,SBC,AND,XOR,OR,CP", "A,sss", Flag.SSS, Flag.ALU).add(192, "RET", "cc", Flag.CC3).add(193, "POP", "rp", Flag.RP2AF).add(194, "JP", "cc,add", Flag.CC3, Flag.ADDLO, Flag.ADDHI).add(195, "JP", "add", Flag.ADDLO, Flag.ADDHI).add(196, "CALL", "cc,add", Flag.CC3, Flag.ADDLO, Flag.ADDHI).add(197, "PUSH", "rp", Flag.RP2AF).add(198, "ADD,ADC,SUB,SBC,AND,XOR,OR,CP", "A,data", Flag.ALU, Flag.DATA).add(199, "RST", "n", Flag.N3).add(201, "RET").add(203, "CB", "", Flag.PREFIX).add(205, "CALL", "add", Flag.ADDLO, Flag.ADDHI).add(211, "OUT", "(port),A", Flag.PORT).add(217, "EXX").add(219, "IN", "A,(port)", Flag.PORT).add(221, "IX", "", Flag.OVERRIDE).add(227, "EX", "(SP),HL", new Flag[0]).add(233, "JP", "(HL)", new Flag[0]).add(235, "EX", "DE,HL", new Flag[0]).add(237, "ED", "", Flag.PREFIX).add(243, "DI").add(249, "LD", "SP,HL", new Flag[0]).add(251, "EI").add(253, "IY", "", Flag.OVERRIDE);
        InstructionSetZ80.with(ED_OPCODES).add(64, "IN", "ddd,(C)", Flag.DDD).add(65, "OUT", "(C),ddd", Flag.DDD).add(66, "SBC", "HL,rp", Flag.RP2SP).add(67, "LD", "(add),rp", Flag.ADDLO, Flag.ADDHI, Flag.RP2SP).add(68, "NEG").add(69, "RETN").add(70, "IM", "0", new Flag[0]).add(86, "IM", "1", new Flag[0]).add(94, "IM", "2", new Flag[0]).add(71, "LD", "I,A", new Flag[0]).add(74, "ADC", "HL,rp", Flag.RP2SP).add(75, "LD", "rp,(add)", Flag.ADDLO, Flag.ADDHI, Flag.RP2SP).add(77, "RETI").add(79, "LD", "R,A", new Flag[0]).add(87, "LD", "A,I", new Flag[0]).add(95, "LD", "A,R", new Flag[0]).add(103, "RRD").add(111, "RLD").add(160, "LDI,LDD,LDIR,LDDR", "", Flag.RD).add(161, "CPI,CPD,CPIR,CPDR", "", Flag.RD).add(162, "INI,IND,INIR,INDR", "", Flag.RD).add(163, "OUTI,OUTD,OTIR,OTDR", "", Flag.RD);
        InstructionSetZ80.with(CB_OPCODES).add(0, "RLC", "sss", Flag.SSS).add(8, "RRC", "sss", Flag.SSS).add(16, "RL", "sss", Flag.SSS).add(24, "RR", "sss", Flag.SSS).add(32, "SLA", "sss", Flag.SSS).add(40, "SRA", "sss", Flag.SSS).add(48, "SLL", "sss", Flag.SSS).add(56, "SRL", "sss", Flag.SSS).add(64, "BIT", "bit,sss", Flag.BIT, Flag.SSS).add(128, "RES", "bit,sss", Flag.BIT, Flag.SSS).add(192, "SET", "bit,sss", Flag.BIT, Flag.SSS);
    }

    record Opcode(int opcode, String mnemonic, String[] fmts, Set<Flag> flags) {
        public Opcode(int opcode, String mnemonic, String fmts, Flag ... flags) {
            this(opcode, mnemonic, fmts.split(","), Set.of(flags));
        }
    }

    static enum Flag {
        RP1,
        RP2SP,
        RP2AF,
        DATLO,
        DATHI,
        DDD,
        SSS,
        DATA,
        OFFSET,
        ADDLO,
        ADDHI,
        CC3,
        CC2,
        PORT,
        ALU,
        N3,
        PREFIX,
        OVERRIDE,
        RD,
        BIT;

    }

    private record OpcodeTableZ80(String name, Opcode[] opcodes) implements InstructionSet.OpcodeTable
    {
        @Override
        public String opcodeExample(int op) {
            Opcode opcode = this.opcodes[op];
            if (opcode == null) {
                return "-";
            }
            String fmt = String.join((CharSequence)",", opcode.fmts).replace("rp", "rr").replace("data", "VALUE").replace("ddd", "r").replace("sss", "r").replace("offset", "ADDR").replace("add", "ADDR");
            return String.format("%s %s", opcode.mnemonic, fmt);
        }
    }

    static class Builder {
        Opcode[] opcodes;

        Builder(Opcode[] opcodes) {
            assert (opcodes.length == 256);
            this.opcodes = opcodes;
        }

        Builder add(int baseOpcode, String mnemonic) {
            return this.add(baseOpcode, mnemonic, "", new Flag[0]);
        }

        Builder add(int baseOpcode, String mnemonic, String template, Flag ... flags) {
            Set<Flag> f = Set.of(flags);
            if (f.contains((Object)Flag.RP1) || f.contains((Object)Flag.RP2SP)) {
                String[] rp = new String[]{"BC", "DE", "HL", "SP"};
                int size = f.contains((Object)Flag.RP1) ? 2 : 4;
                for (int i = 0; i < size; ++i) {
                    int opcode = baseOpcode | i << 4;
                    assert (this.opcodes[opcode] == null);
                    this.opcodes[opcode] = new Opcode(opcode, mnemonic, template.replace("rp", rp[i]), flags);
                }
            } else if (f.contains((Object)Flag.RP2AF)) {
                String[] rp = new String[]{"BC", "DE", "HL", "AF"};
                int size = f.contains((Object)Flag.RP1) ? 2 : 4;
                for (int i = 0; i < size; ++i) {
                    int opcode = baseOpcode | i << 4;
                    assert (this.opcodes[opcode] == null);
                    this.opcodes[opcode] = new Opcode(opcode, mnemonic, template.replace("rp", rp[i]), flags);
                }
            } else if (f.contains((Object)Flag.CC2) || f.contains((Object)Flag.CC3)) {
                String[] cc = new String[]{"NZ", "Z", "NC", "C", "PO", "PE", "P", "M"};
                int size = f.contains((Object)Flag.CC2) ? 4 : 8;
                for (int i = 0; i < size; ++i) {
                    int opcode = baseOpcode | i << 3;
                    assert (this.opcodes[opcode] == null);
                    this.opcodes[opcode] = new Opcode(opcode, mnemonic, template.replace("cc", cc[i]), flags);
                }
            } else if (f.contains((Object)Flag.N3)) {
                for (int i = 0; i < 8; ++i) {
                    int n = i << 3;
                    int opcode = baseOpcode | n;
                    assert (this.opcodes[opcode] == null);
                    this.opcodes[opcode] = new Opcode(opcode, mnemonic, template.replace("n", String.format("%02XH", n)), flags);
                }
            } else if (f.contains((Object)Flag.RD)) {
                String[] mnemonics = mnemonic.split(",");
                assert (mnemonics.length == 4);
                for (int i = 0; i < 4; ++i) {
                    int opcode = baseOpcode | i << 3;
                    assert (this.opcodes[opcode] == null);
                    this.opcodes[opcode] = new Opcode(opcode, mnemonics[i], template, flags);
                }
            } else if (f.contains((Object)Flag.DDD) && f.contains((Object)Flag.SSS)) {
                String[] regs = new String[]{"B", "C", "D", "E", "H", "L", "(HL)", "A"};
                for (int d = 0; d < 8; ++d) {
                    String ddd = regs[d];
                    for (int s = 0; s < 8; ++s) {
                        if (d == 6 && s == 6) continue;
                        String sss = regs[s];
                        int opcode = baseOpcode | d << 3 | s;
                        assert (this.opcodes[opcode] == null);
                        this.opcodes[opcode] = new Opcode(opcode, mnemonic, template.replace("ddd", ddd).replace("sss", sss), flags);
                    }
                }
            } else if (f.contains((Object)Flag.ALU) && f.contains((Object)Flag.SSS)) {
                String[] regs = new String[]{"B", "C", "D", "E", "H", "L", "(HL)", "A"};
                String[] mnemonics = mnemonic.split(",");
                assert (mnemonics.length == 8);
                for (int i = 0; i < 8; ++i) {
                    for (int s = 0; s < 8; ++s) {
                        String sss = regs[s];
                        int opcode = baseOpcode | i << 3 | s;
                        assert (this.opcodes[opcode] == null);
                        this.opcodes[opcode] = new Opcode(opcode, mnemonics[i], template.replace("sss", sss), flags);
                    }
                }
            } else if (f.contains((Object)Flag.BIT) && f.contains((Object)Flag.SSS)) {
                String[] regs = new String[]{"B", "C", "D", "E", "H", "L", "(HL)", "A"};
                for (int i = 0; i < 8; ++i) {
                    String bit = Integer.toString(i);
                    for (int s = 0; s < 8; ++s) {
                        String sss = regs[s];
                        int opcode = baseOpcode | i << 3 | s;
                        assert (this.opcodes[opcode] == null);
                        this.opcodes[opcode] = new Opcode(opcode, mnemonic, template.replace("bit", bit).replace("sss", sss), flags);
                    }
                }
            } else if (f.contains((Object)Flag.DDD)) {
                String[] regs = new String[]{"B", "C", "D", "E", "H", "L", "(HL)", "A"};
                for (int d = 0; d < 8; ++d) {
                    String ddd = regs[d];
                    int opcode = baseOpcode | d << 3;
                    assert (this.opcodes[opcode] == null);
                    this.opcodes[opcode] = new Opcode(opcode, mnemonic, template.replace("ddd", ddd), flags);
                }
            } else if (f.contains((Object)Flag.SSS)) {
                String[] regs = new String[]{"B", "C", "D", "E", "H", "L", "(HL)", "A"};
                for (int s = 0; s < 8; ++s) {
                    String sss = regs[s];
                    int opcode = baseOpcode | s;
                    assert (this.opcodes[opcode] == null);
                    this.opcodes[opcode] = new Opcode(opcode, mnemonic, template.replace("sss", sss), flags);
                }
            } else if (f.contains((Object)Flag.ALU)) {
                String[] mnemonics = mnemonic.split(",");
                assert (mnemonics.length == 8);
                for (int i = 0; i < 8; ++i) {
                    int opcode = baseOpcode | i << 3;
                    assert (this.opcodes[opcode] == null);
                    this.opcodes[opcode] = new Opcode(opcode, mnemonics[i], template, flags);
                }
            } else {
                assert (this.opcodes[baseOpcode] == null);
                this.opcodes[baseOpcode] = new Opcode(baseOpcode, mnemonic, template, flags);
            }
            return this;
        }
    }
}

