/*
 * Decompiled with CFR 0.152.
 */
package org.applecommander.disassembler.api;

import java.util.Collections;
import java.util.List;
import org.applecommander.disassembler.api.Instruction;
import org.applecommander.disassembler.api.Program;

public interface InstructionSet {
    public Defaults defaults();

    public List<Instruction> decode(Program var1);

    public List<OpcodeTable> opcodeTables();

    public record Defaults(int startAddress, List<String> libraryLabels, int bytesPerInstruction, boolean includeDescription) {
        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private int startAddress;
            private List<String> libraryLabels = Collections.emptyList();
            private int bytesPerInstruction;
            private boolean includeDescription;

            public Builder startAddress(int startAddress) {
                this.startAddress = startAddress;
                return this;
            }

            public Builder libraryLabels(String ... libraryLabels) {
                this.libraryLabels = List.of(libraryLabels);
                return this;
            }

            public Builder bytesPerInstruction(int bytesPerInstruction) {
                this.bytesPerInstruction = bytesPerInstruction;
                return this;
            }

            public Builder includeDescription(boolean includeDescription) {
                this.includeDescription = includeDescription;
                return this;
            }

            public Defaults get() {
                return new Defaults(this.startAddress, this.libraryLabels, this.bytesPerInstruction, this.includeDescription);
            }
        }
    }

    public static interface OpcodeTable {
        public String name();

        public String opcodeExample(int var1);
    }
}

