/*
 * Decompiled with CFR 0.152.
 */
package org.applecommander.disassembler.api;

import java.util.Arrays;
import java.util.Objects;

public class Program {
    static final int ADDRESS_SPACE = 65536;
    private final int baseAddress;
    private final byte[] code;
    private int offset;

    public Program(byte[] code, int address) {
        Objects.requireNonNull(code);
        this.baseAddress = address;
        this.code = code;
        this.offset = 0;
    }

    public int length() {
        return this.code.length;
    }

    public boolean hasMore() {
        return this.offset < this.code.length;
    }

    public int peekUnsignedByte() {
        return this.peekUnsignedByte(0);
    }

    public int peekUnsignedByte(int n) {
        return this.offset + n < this.code.length ? Byte.toUnsignedInt(this.code[this.offset + n]) : 0;
    }

    public int peekUnsignedShort(int n) {
        return this.peekUnsignedByte(n) | this.peekUnsignedByte(n + 1) << 8;
    }

    public int peekSignedByte(int n) {
        return this.offset + n < this.code.length ? this.code[this.offset + n] : 0;
    }

    public byte[] read(int n) {
        byte[] x = Arrays.copyOfRange(this.code, this.offset, this.offset + n);
        this.offset += n;
        return x;
    }

    public int getUnsignedByte(int n) {
        return n < this.code.length ? Byte.toUnsignedInt(this.code[n]) : 0;
    }

    public int currentOffset() {
        return this.offset;
    }

    public int baseAddress() {
        return this.baseAddress;
    }

    public int currentAddress() {
        return (this.baseAddress + this.offset) % 65536;
    }
}

