/*
 * Decompiled with CFR 0.152.
 */
package org.applecommander.disassembler.api.mos6502;

import java.util.ArrayList;
import java.util.List;
import org.applecommander.disassembler.api.Instruction;
import org.applecommander.disassembler.api.InstructionSet;
import org.applecommander.disassembler.api.Program;
import org.applecommander.disassembler.api.mos6502.AddressMode6502;
import org.applecommander.disassembler.api.mos6502.Opcode6502;

public class InstructionSet6502
implements InstructionSet {
    private final AddressMode6502[] addressModes;
    private final Opcode6502[] opcodes;
    private final String name;

    public static InstructionSet6502 for6502() {
        return new InstructionSet6502("6502", AddressMode6502.MOS6502, Opcode6502.MOS6502);
    }

    public static InstructionSet6502 for6502withIllegalInstructions() {
        return new InstructionSet6502("6502X", AddressMode6502.MOS6502, Opcode6502.MOS6502_WITH_ILLEGAL);
    }

    public static InstructionSet6502 for65C02() {
        return new InstructionSet6502("65C02", AddressMode6502.WDC65C02, Opcode6502.WDC65C02);
    }

    private InstructionSet6502(String name, AddressMode6502[] addressModes, Opcode6502[] opcodes) {
        this.name = name;
        this.addressModes = addressModes;
        this.opcodes = opcodes;
    }

    @Override
    public InstructionSet.Defaults defaults() {
        return InstructionSet.Defaults.builder().startAddress(768).libraryLabels("All").bytesPerInstruction(3).get();
    }

    @Override
    public List<Instruction> decode(Program program) {
        ArrayList<Instruction> assembly = new ArrayList<Instruction>();
        while (program.hasMore()) {
            assembly.add(this.decodeOne(program));
        }
        return assembly;
    }

    public Instruction decodeOne(Program program) {
        int op = program.peekUnsignedByte();
        AddressMode6502 addressMode = this.addressModes[op];
        Opcode6502 opcode = this.opcodes[op];
        int currentAddress = program.currentAddress();
        int value = switch (addressMode.getInstructionLength()) {
            case 3 -> program.peekUnsignedShort(1);
            case 2 -> {
                if (addressMode.isOperandRelativeAddress()) {
                    yield currentAddress + 2 + program.peekSignedByte(1) & 0xFFFF;
                }
                yield program.peekUnsignedByte(1);
            }
            default -> 0;
        };
        Instruction.Builder builder = Instruction.at(currentAddress).code(program.read(addressMode.getInstructionLength())).mnemonic(opcode.getMnemonic());
        switch (addressMode) {
            case ACC: 
            case IMP: 
            case ZZZ1: {
                break;
            }
            case ABS: 
            case REL: 
            case ZZZ3: {
                builder.opAddress("%s", "$%04X", value);
                break;
            }
            case ABSX: {
                builder.opAddress("%s", "$%04X", value).opValue("X", new Object[0]);
                break;
            }
            case ABSY: {
                builder.opAddress("%s", "$%04X", value).opValue("Y", new Object[0]);
                break;
            }
            case IMM: {
                builder.opValue("#$%02X", value);
                break;
            }
            case INDABS: {
                builder.opAddress("(%s)", "$%04X", value);
                break;
            }
            case INDABSX: {
                builder.opAddress("(%s", "$%04X", value).opValue("X)", new Object[0]);
                break;
            }
            case INDZP: {
                builder.opAddress("(%s)", "$%02X", value);
                break;
            }
            case INDZPX: {
                builder.opAddress("(%s", "$%02X", value).opValue("X)", new Object[0]);
                break;
            }
            case INDZPY: {
                builder.opAddress("(%s)", "$%02X", value).opValue("Y", new Object[0]);
                break;
            }
            case ZP: 
            case ZZZ2: {
                builder.opAddress("%s", "$%02X", value);
                break;
            }
            case ZPX: {
                builder.opAddress("%s", "$%02X", value).opValue("X", new Object[0]);
                break;
            }
            case ZPY: {
                builder.opAddress("%s", "$%02X", value).opValue("Y", new Object[0]);
            }
        }
        return builder.get();
    }

    @Override
    public List<InstructionSet.OpcodeTable> opcodeTables() {
        return List.of(new OpcodeTable6502());
    }

    private class OpcodeTable6502
    implements InstructionSet.OpcodeTable {
        private OpcodeTable6502() {
        }

        @Override
        public String name() {
            return InstructionSet6502.this.name;
        }

        @Override
        public String opcodeExample(int op) {
            AddressMode6502 addressMode = InstructionSet6502.this.addressModes[op];
            Opcode6502 opcode = InstructionSet6502.this.opcodes[op];
            if (opcode == Opcode6502.ZZZ) {
                return "-";
            }
            String name = opcode.getMnemonic();
            return switch (addressMode) {
                default -> throw new MatchException(null, null);
                case AddressMode6502.ACC, AddressMode6502.IMP, AddressMode6502.ZZZ1 -> name;
                case AddressMode6502.ABS, AddressMode6502.REL, AddressMode6502.ZZZ3 -> String.format("%s ADDR", name);
                case AddressMode6502.ABSX -> String.format("%s ADDR,X", name);
                case AddressMode6502.ABSY -> String.format("%s ADDR,Y", name);
                case AddressMode6502.IMM -> String.format("%s #VALUE", name);
                case AddressMode6502.INDABS -> String.format("%s (ADDR)", name);
                case AddressMode6502.INDABSX -> String.format("%s (ADDR,X)", name);
                case AddressMode6502.INDZP -> String.format("%s (ZP)", name);
                case AddressMode6502.INDZPX -> String.format("%s (ZP,X)", name);
                case AddressMode6502.INDZPY -> String.format("%s (ZP),Y", name);
                case AddressMode6502.ZP -> String.format("%s ZP", name);
                case AddressMode6502.ZPX -> String.format("%s ZP,X", name);
                case AddressMode6502.ZPY -> String.format("%s ZP,Y", name);
                case AddressMode6502.ZZZ2 -> String.format("%s VALUE", name);
            };
        }
    }
}

