/*
 * Decompiled with CFR 0.152.
 */
package org.applecommander.disassembler.api.sweet16;

public enum AddressModeSWEET16 {
    CON(3),
    DIR(1),
    IND(1),
    BRA(2),
    IMP(1);

    private final int instructionLength;
    public static final AddressModeSWEET16[] REGISTER_OPS;
    public static final AddressModeSWEET16[] NON_REGISTER_OPS;

    private AddressModeSWEET16(int instructionLength) {
        this.instructionLength = instructionLength;
    }

    public int getInstructionLength() {
        return this.instructionLength;
    }

    public boolean isOperandRelativeAddress() {
        return this.is(BRA);
    }

    public boolean doesOperandRequireRegister() {
        return this.is(CON, DIR, IND);
    }

    private boolean is(AddressModeSWEET16 ... addressModes) {
        for (AddressModeSWEET16 am : addressModes) {
            if (this != am) continue;
            return true;
        }
        return false;
    }

    static {
        REGISTER_OPS = new AddressModeSWEET16[]{null, CON, DIR, DIR, IND, IND, IND, IND, IND, IND, DIR, DIR, IND, DIR, DIR, DIR};
        NON_REGISTER_OPS = new AddressModeSWEET16[]{IMP, BRA, BRA, BRA, BRA, BRA, BRA, BRA, BRA, BRA, IMP, IMP, BRA, IMP, IMP, IMP};
    }
}

