/*
 * Decompiled with CFR 0.152.
 */
package org.appng.camunda.bpm;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.appng.api.Environment;
import org.appng.api.FieldProcessor;
import org.appng.api.Options;
import org.appng.api.Request;
import org.appng.api.model.Application;
import org.appng.api.model.Site;
import org.appng.xml.platform.FieldDef;
import org.appng.xml.platform.FieldType;
import org.appng.xml.platform.Label;
import org.appng.xml.platform.Message;
import org.appng.xml.platform.MessageType;
import org.appng.xml.platform.NotNull;
import org.appng.xml.platform.Validation;
import org.camunda.bpm.engine.form.FormField;
import org.camunda.bpm.engine.form.FormFieldValidationConstraint;
import org.camunda.bpm.engine.form.FormType;
import org.camunda.bpm.engine.form.TaskFormData;
import org.camunda.bpm.engine.impl.form.type.BooleanFormType;
import org.camunda.bpm.engine.impl.form.type.DateFormType;
import org.camunda.bpm.engine.impl.form.type.LongFormType;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.task.DelegationState;
import org.camunda.bpm.engine.task.IdentityLink;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.variable.VariableMap;

public class TaskWrapper
implements Task {
    private static final String VC_REQUIRED = "required";
    private static final String VC_READONLY = "readonly";
    private Task task;
    private String candidateUser;
    private String candidateGroup;
    private VariableMap variables;
    private Map<String, Object> formFields = new HashMap<String, Object>();

    public TaskWrapper() {
        this((Task)new TaskEntity(), Collections.emptyList(), null);
    }

    public TaskWrapper(Task task, Collection<IdentityLink> identityLinks, VariableMap variables) {
        this.task = task;
        this.variables = variables;
        for (IdentityLink il : identityLinks) {
            if (!"candidate".equals(il.getType())) continue;
            if (StringUtils.isNotBlank((CharSequence)il.getGroupId())) {
                this.candidateGroup = il.getGroupId();
                continue;
            }
            if (!StringUtils.isNotBlank((CharSequence)il.getUserId())) continue;
            this.candidateUser = il.getUserId();
        }
    }

    public void addFormFields(FieldProcessor fp, TaskFormData taskFormData, String mandatoryMessage) {
        for (FormField formField : taskFormData.getFormFields()) {
            String fieldName = this.getFieldName(formField);
            if (fp.hasField(fieldName)) continue;
            FieldDef field = new FieldDef();
            this.determineFieldType(formField.getType(), field);
            field.setName(fieldName);
            field.setBinding(field.getName());
            Label label = new Label();
            label.setValue(formField.getLabel());
            field.setLabel(label);
            List validationConstraints = formField.getValidationConstraints();
            if (validationConstraints.size() > 0) {
                field.setValidation(new Validation());
                for (FormFieldValidationConstraint validationConstraint : validationConstraints) {
                    this.addValidation(field, validationConstraint, mandatoryMessage);
                }
            }
            fp.getMetaData().getFields().add(field);
            this.formFields.put(formField.getId(), formField.getValue().getValue());
        }
    }

    protected void addValidation(FieldDef field, FormFieldValidationConstraint validationConstraint, String mandatoryMessage) {
        if (VC_REQUIRED.equals(validationConstraint.getName())) {
            NotNull notNull = new NotNull();
            Message mssg = new Message();
            mssg.setClazz(MessageType.ERROR);
            mssg.setRef(field.getBinding());
            mssg.setContent(mandatoryMessage);
            notNull.setMessage(mssg);
            field.getValidation().setNotNull(notNull);
        }
        if (VC_READONLY.equals(validationConstraint.getName())) {
            field.setReadonly("true");
        }
    }

    protected void determineFieldType(FormType type, FieldDef field) {
        if (type instanceof BooleanFormType) {
            field.setType(FieldType.CHECKBOX);
        } else if (type instanceof LongFormType) {
            field.setType(FieldType.LONG);
        } else if (type instanceof DateFormType) {
            field.setType(FieldType.DATE);
            Object datePattern = type.getInformation("datePattern");
            field.setFormat((String)datePattern);
        } else {
            field.setType(FieldType.TEXT);
        }
    }

    public void validate(Site site, Application application, Environment environment, Options options, Request request, FieldProcessor fp, TaskFormData taskFormData, String requiredMessage) {
        for (FormField formField : taskFormData.getFormFields()) {
            List validationConstraints = formField.getValidationConstraints();
            for (FormFieldValidationConstraint validationConstraint : validationConstraints) {
                Object value;
                if (!VC_REQUIRED.equals(validationConstraint.getName()) || null != (value = this.getFormField(formField.getId())) && (!(value instanceof String) || !StringUtils.isBlank((CharSequence)((String)value)))) continue;
                String fieldName = this.getFieldName(formField);
                fp.addErrorMessage(fp.getField(fieldName), requiredMessage);
            }
        }
    }

    private String getFieldName(FormField formField) {
        return String.format("formFields['%s']", formField.getId());
    }

    public Object getFormField(String name) {
        return this.formFields.get(name);
    }

    public Task getTask() {
        return this.task;
    }

    public String getCandidateUser() {
        return this.candidateUser;
    }

    public String getCandidateGroup() {
        return this.candidateGroup;
    }

    public VariableMap getVariables() {
        return this.variables;
    }

    public Map<String, Object> getFormFields() {
        return this.formFields;
    }

    public void setTask(Task task) {
        this.task = task;
    }

    public void setCandidateUser(String candidateUser) {
        this.candidateUser = candidateUser;
    }

    public void setCandidateGroup(String candidateGroup) {
        this.candidateGroup = candidateGroup;
    }

    public void setVariables(VariableMap variables) {
        this.variables = variables;
    }

    public void setFormFields(Map<String, Object> formFields) {
        this.formFields = formFields;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskWrapper)) {
            return false;
        }
        TaskWrapper other = (TaskWrapper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Task this$task = this.getTask();
        Task other$task = other.getTask();
        if (this$task == null ? other$task != null : !this$task.equals(other$task)) {
            return false;
        }
        String this$candidateUser = this.getCandidateUser();
        String other$candidateUser = other.getCandidateUser();
        if (this$candidateUser == null ? other$candidateUser != null : !this$candidateUser.equals(other$candidateUser)) {
            return false;
        }
        String this$candidateGroup = this.getCandidateGroup();
        String other$candidateGroup = other.getCandidateGroup();
        if (this$candidateGroup == null ? other$candidateGroup != null : !this$candidateGroup.equals(other$candidateGroup)) {
            return false;
        }
        VariableMap this$variables = this.getVariables();
        VariableMap other$variables = other.getVariables();
        if (this$variables == null ? other$variables != null : !this$variables.equals(other$variables)) {
            return false;
        }
        Map<String, Object> this$formFields = this.getFormFields();
        Map<String, Object> other$formFields = other.getFormFields();
        return !(this$formFields == null ? other$formFields != null : !((Object)this$formFields).equals(other$formFields));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TaskWrapper;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Task $task = this.getTask();
        result = result * 59 + ($task == null ? 43 : $task.hashCode());
        String $candidateUser = this.getCandidateUser();
        result = result * 59 + ($candidateUser == null ? 43 : $candidateUser.hashCode());
        String $candidateGroup = this.getCandidateGroup();
        result = result * 59 + ($candidateGroup == null ? 43 : $candidateGroup.hashCode());
        VariableMap $variables = this.getVariables();
        result = result * 59 + ($variables == null ? 43 : $variables.hashCode());
        Map<String, Object> $formFields = this.getFormFields();
        result = result * 59 + ($formFields == null ? 43 : ((Object)$formFields).hashCode());
        return result;
    }

    public String toString() {
        return "TaskWrapper(task=" + this.getTask() + ", candidateUser=" + this.getCandidateUser() + ", candidateGroup=" + this.getCandidateGroup() + ", variables=" + this.getVariables() + ", formFields=" + this.getFormFields() + ")";
    }

    public String getId() {
        return this.getTask().getId();
    }

    public String getName() {
        return this.getTask().getName();
    }

    public void setName(String arg0) {
        this.getTask().setName(arg0);
    }

    public String getDescription() {
        return this.getTask().getDescription();
    }

    public void setDescription(String arg0) {
        this.getTask().setDescription(arg0);
    }

    public int getPriority() {
        return this.getTask().getPriority();
    }

    public void setPriority(int arg0) {
        this.getTask().setPriority(arg0);
    }

    public String getOwner() {
        return this.getTask().getOwner();
    }

    public void setOwner(String arg0) {
        this.getTask().setOwner(arg0);
    }

    public String getAssignee() {
        return this.getTask().getAssignee();
    }

    public void setAssignee(String arg0) {
        this.getTask().setAssignee(arg0);
    }

    public DelegationState getDelegationState() {
        return this.getTask().getDelegationState();
    }

    public void setDelegationState(DelegationState arg0) {
        this.getTask().setDelegationState(arg0);
    }

    public String getProcessInstanceId() {
        return this.getTask().getProcessInstanceId();
    }

    public String getExecutionId() {
        return this.getTask().getExecutionId();
    }

    public String getProcessDefinitionId() {
        return this.getTask().getProcessDefinitionId();
    }

    public String getCaseInstanceId() {
        return this.getTask().getCaseInstanceId();
    }

    public void setCaseInstanceId(String arg0) {
        this.getTask().setCaseInstanceId(arg0);
    }

    public String getCaseExecutionId() {
        return this.getTask().getCaseExecutionId();
    }

    public String getCaseDefinitionId() {
        return this.getTask().getCaseDefinitionId();
    }

    public Date getCreateTime() {
        return this.getTask().getCreateTime();
    }

    public String getTaskDefinitionKey() {
        return this.getTask().getTaskDefinitionKey();
    }

    public Date getDueDate() {
        return this.getTask().getDueDate();
    }

    public void setDueDate(Date arg0) {
        this.getTask().setDueDate(arg0);
    }

    public Date getFollowUpDate() {
        return this.getTask().getFollowUpDate();
    }

    public void setFollowUpDate(Date arg0) {
        this.getTask().setFollowUpDate(arg0);
    }

    public void delegate(String arg0) {
        this.getTask().delegate(arg0);
    }

    public void setParentTaskId(String arg0) {
        this.getTask().setParentTaskId(arg0);
    }

    public String getParentTaskId() {
        return this.getTask().getParentTaskId();
    }

    public boolean isSuspended() {
        return this.getTask().isSuspended();
    }

    public String getFormKey() {
        return this.getTask().getFormKey();
    }

    public String getTenantId() {
        return this.getTask().getTenantId();
    }

    public void setTenantId(String arg0) {
        this.getTask().setTenantId(arg0);
    }
}

