/*
 * Decompiled with CFR 0.152.
 */
package org.appng.mail.impl;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.appng.mail.Address;
import org.appng.mail.Attachment;
import org.appng.mail.Mail;
import org.appng.mail.MailException;
import org.appng.mail.MailTransport;
import org.appng.mail.Receiver;
import org.appng.mail.impl.MailImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTransport
implements MailTransport {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DefaultTransport.class);
    protected static final String TEXT_HTML = "text/html";
    protected static final String CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding";
    protected static final String UTF_8 = "UTF-8";
    protected static final String MIXED = "mixed";
    protected static final String ALTERNATIVE = "alternative";
    public static final String HOST = "mail.smtp.host";
    public static final String PORT = "mail.smtp.port";
    protected Session session;
    protected Properties p;
    protected boolean disableSend = false;
    protected boolean debug = false;

    protected DefaultTransport() {
    }

    public DefaultTransport(Session session) {
        this.session = session;
    }

    public DefaultTransport(String host, int port) {
        this.p = new Properties();
        this.p.put(HOST, host);
        this.p.put(PORT, (Object)port);
        this.session = Session.getInstance((Properties)this.p);
    }

    public DefaultTransport(Properties props) {
        this.p = props;
        this.session = Session.getInstance((Properties)this.p);
    }

    public DefaultTransport(Properties props, String user, String password) {
        this.p = props;
        final PasswordAuthentication pa = new PasswordAuthentication(user, password);
        Authenticator authenticator = new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return pa;
            }
        };
        this.session = Session.getInstance((Properties)this.p, (Authenticator)authenticator);
    }

    @Override
    public Mail createMail() {
        return new MailImpl();
    }

    @Override
    public void send(Mail mail) throws MailException {
        ArrayList<String> invalid = new ArrayList<String>();
        try {
            this.send(mail, invalid);
        }
        catch (MailException e) {
            if (!invalid.isEmpty()) {
                mail.markInvalidReceivers(invalid);
            }
            throw e;
        }
    }

    @Override
    public String getMailAsString(Mail mail) {
        return mail.toString();
    }

    private String getLineBreak() {
        return System.getProperty("line.separator");
    }

    protected void send(Mail mail, Collection<String> invalidAdresses) throws MailException {
        if (this.isEmpty(mail.getFrom())) {
            throw new MailException("e-mail can not be send because it has no sender!");
        }
        if (this.isEmpty(mail.getSubject())) {
            throw new MailException("e-mail can not be send because it has no subject!");
        }
        if (!mail.hasReceivers()) {
            throw new MailException("e-mail can not be send because it has no receivers!");
        }
        if (this.disableSend) {
            LOGGER.info("sending is disabled, not sending message" + this.getLineBreak() + this.getMailAsString(mail));
        } else {
            try {
                Message message = this.buildMessage(mail);
                Transport.send((Message)message);
            }
            catch (Exception e) {
                javax.mail.Address[] invalidAddresses;
                if (e instanceof MailException) {
                    throw (MailException)e;
                }
                if (e instanceof SendFailedException && null != (invalidAddresses = ((SendFailedException)e).getInvalidAddresses())) {
                    for (javax.mail.Address address : invalidAddresses) {
                        String email = ((InternetAddress)address).getAddress();
                        if (null != invalidAddresses) {
                            invalidAdresses.add(email);
                        }
                        LOGGER.warn("invalid address: '" + email + "'");
                    }
                }
                throw new MailException(e);
            }
        }
    }

    private boolean isEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    protected Message buildMessage(Mail mail) throws MailException {
        this.session.setDebug(this.debug);
        MimeMessage mimeMessage = new MimeMessage(this.session);
        return this.buildMessage((Message)mimeMessage, mail);
    }

    protected Message buildMessage(Message mimeMessage, Mail mail) throws MailException {
        try {
            boolean hasAttachments;
            String htmlContent;
            String encoding;
            for (Receiver receiver : mail.getReceivers()) {
                if (!receiver.isValid()) continue;
                Mail.RecipientType type = receiver.getType();
                Message.RecipientType messageType = this.getRealType(type);
                mimeMessage.addRecipient(messageType, this.toAddress(receiver));
            }
            List<Receiver> replyTo = mail.getReplyTo();
            javax.mail.Address[] replyArr = new javax.mail.Address[replyTo.size()];
            for (int i = 0; i < replyArr.length; ++i) {
                replyArr[i] = this.toAddress(replyTo.get(i));
            }
            mimeMessage.setReplyTo(replyArr);
            mimeMessage.setSubject(mail.getSubject());
            mimeMessage.setFrom(this.toAddress(mail.getFromAddress()));
            mimeMessage.setSentDate(new Date());
            MimeMultipart multipartAlternative = new MimeMultipart(ALTERNATIVE);
            String textContent = mail.getTextContent();
            String string = encoding = mail.getEncoding() == null ? UTF_8 : mail.getEncoding();
            if (null != textContent) {
                MimeBodyPart bodyPart = new MimeBodyPart();
                bodyPart.setText(textContent, encoding);
                multipartAlternative.addBodyPart((BodyPart)bodyPart);
            }
            if (null != (htmlContent = mail.getHtmlContent())) {
                MimeBodyPart bodyPart = new MimeBodyPart();
                bodyPart.setContent((Object)htmlContent, "text/html; charset=" + encoding);
                bodyPart.setHeader(CONTENT_TRANSFER_ENCODING, "7bit");
                multipartAlternative.addBodyPart((BodyPart)bodyPart);
            }
            if (hasAttachments = mail.hasAttachments()) {
                MimeMultipart multipartMixed = new MimeMultipart(MIXED);
                MimeBodyPart bodyPart = new MimeBodyPart();
                bodyPart.setContent((Multipart)multipartAlternative);
                multipartMixed.addBodyPart((BodyPart)bodyPart);
                for (Attachment attachment : mail.getAttachments()) {
                    this.addAttachment(multipartMixed, attachment);
                }
                mimeMessage.setContent((Multipart)multipartMixed);
            } else {
                mimeMessage.setContent((Multipart)multipartAlternative);
            }
            mimeMessage.saveChanges();
            return mimeMessage;
        }
        catch (Exception e) {
            throw new MailException(e);
        }
    }

    private Message.RecipientType getRealType(Mail.RecipientType type) {
        switch (type) {
            case CC: {
                return Message.RecipientType.CC;
            }
            case BCC: {
                return Message.RecipientType.BCC;
            }
        }
        return Message.RecipientType.TO;
    }

    private void addAttachment(MimeMultipart multipartMixed, Attachment attachment) throws Exception {
        ByteArrayDataSource ds = new ByteArrayDataSource(attachment.getInputStream(), attachment.getMimeType());
        ds.setName(attachment.getName());
        MimeBodyPart attachmentPart = new MimeBodyPart();
        attachmentPart.setDataHandler(new DataHandler((DataSource)ds));
        attachmentPart.setFileName(attachment.getName());
        attachmentPart.setDisposition("attachment");
        multipartMixed.addBodyPart((BodyPart)attachmentPart);
    }

    public void disableSend() {
        this.disableSend = true;
    }

    @Override
    public boolean isDisableSend() {
        return this.disableSend;
    }

    @Override
    public void setDisableSend(boolean disableSend) {
        this.disableSend = disableSend;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public javax.mail.Address toAddress(Address address) throws UnsupportedEncodingException {
        return new InternetAddress(address.getEmail(), address.getName());
    }
}

