/*
 * Decompiled with CFR 0.152.
 */
package org.appng.mail.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.activation.MimetypesFileTypeMap;
import org.appng.mail.Address;
import org.appng.mail.Attachment;
import org.appng.mail.Mail;
import org.appng.mail.MailException;
import org.appng.mail.Receiver;
import org.appng.mail.impl.AttachmentImpl;

public class MailImpl
implements Mail {
    private List<Receiver> receivers;
    private List<Receiver> replyTo = new ArrayList<Receiver>();
    private List<Attachment> attachments;
    private Address from;
    private String subject;
    private String htmlContent;
    private String textContent;
    private String encoding;

    MailImpl() {
        this.receivers = new ArrayList<Receiver>();
        this.attachments = new ArrayList<Attachment>();
    }

    @Override
    public Mail addReceiver(Receiver receiver) {
        this.receivers.add(receiver);
        return this;
    }

    @Override
    public Mail addReceiver(String email, Mail.RecipientType type) {
        this.receivers.add(new Receiver(email, type));
        return this;
    }

    @Override
    public Mail addReceiver(String email, String name, Mail.RecipientType type) {
        this.receivers.add(new Receiver(email, name, type));
        return this;
    }

    @Override
    public void markInvalidReceivers(List<String> invalid) {
        for (Receiver receiver : this.receivers) {
            if (invalid.indexOf(receiver.getEmail()) < 0) continue;
            receiver.markInvalid();
        }
    }

    @Override
    public Mail setHTMLContent(String content) {
        this.htmlContent = content;
        return this;
    }

    @Override
    public Mail setTextContent(String content) {
        this.textContent = content;
        return this;
    }

    @Override
    public Mail addAttachment(File file, String mimeType) throws MailException {
        this.addAttachment(file, file.getName(), mimeType);
        return this;
    }

    @Override
    public Mail addAttachment(File file, String name, String mimeType) throws MailException {
        if (null == mimeType) {
            mimeType = MimetypesFileTypeMap.getDefaultFileTypeMap().getContentType(file);
        }
        try {
            this.attachments.add(new AttachmentImpl(new FileInputStream(file), name, mimeType));
        }
        catch (FileNotFoundException e) {
            throw new MailException("error adding attachment", e);
        }
        return this;
    }

    @Override
    public Mail addAttachment(InputStream is, String name, String mimeType) throws MailException {
        this.attachments.add(new AttachmentImpl(is, name, mimeType));
        return this;
    }

    @Override
    public boolean hasAttachments() {
        return this.getAttachments().size() > 0;
    }

    @Override
    public Mail setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public Mail setFrom(Address from) {
        this.from = from;
        return this;
    }

    @Override
    public Mail setFrom(String from) {
        this.setFrom(from, null);
        return this;
    }

    @Override
    public Mail setFrom(String from, String name) {
        this.from = new Address(from, name);
        return this;
    }

    @Override
    public Mail addReplyTo(String email) {
        this.replyTo.add(new Receiver(email, (Mail.RecipientType)null));
        return this;
    }

    @Override
    public Mail addReplyTo(String email, String name) {
        this.replyTo.add(new Receiver(email, name, null));
        return this;
    }

    @Override
    public List<Receiver> getReceivers() {
        return this.receivers;
    }

    @Override
    public List<Receiver> getReplyTo() {
        return this.replyTo;
    }

    @Override
    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    @Override
    public String getFrom() {
        return this.from == null ? null : this.from.getEmail();
    }

    @Override
    public Address getFromAddress() {
        return this.from;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public String getHtmlContent() {
        return this.htmlContent;
    }

    @Override
    public String getTextContent() {
        return this.textContent;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String toString() {
        String sep = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        sb.append("Subject: " + this.subject + sep);
        sb.append("From: " + this.from + sep);
        sb.append("Receivers: " + this.receivers + sep);
        sb.append("ReplyTo: " + this.replyTo + sep);
        sb.append("------------------------------------------------------------------" + sep);
        sb.append("Content (Text):" + sep + this.textContent + sep);
        sb.append("------------------------------------------------------------------" + sep);
        sb.append("Content (HTML):" + sep + this.htmlContent + sep);
        sb.append("------------------------------------------------------------------" + sep);
        sb.append("Attachments:" + sep + this.attachments + sep);
        return sb.toString();
    }

    @Override
    public boolean hasReceivers() {
        return !this.getReceivers().isEmpty();
    }
}

