/*
 * Decompiled with CFR 0.152.
 */
package org.appng.tools.poi;

import java.awt.Color;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;

public class FontBuilder {
    private Workbook workbook;
    private short colorIdx = (short)55;
    private Color color;
    private short size;
    private String name;
    private boolean italic;
    private boolean strikeout;
    private boolean bold;
    private byte underline;

    public FontBuilder(Workbook workbook) {
        this.workbook = workbook;
        this.reset();
    }

    public FontBuilder color(String hexcode) {
        Color color = Color.decode(hexcode);
        return this.color(color);
    }

    public FontBuilder color(Color color) {
        this.color = color;
        return this;
    }

    public FontBuilder size(short size) {
        this.size = size;
        return this;
    }

    public FontBuilder name(String name) {
        this.name = name;
        return this;
    }

    public FontBuilder italic() {
        this.italic = true;
        return this;
    }

    public FontBuilder strikeout() {
        this.strikeout = true;
        return this;
    }

    public FontBuilder bold() {
        this.bold = true;
        return this;
    }

    public FontBuilder underline() {
        this.underline = 1;
        return this;
    }

    public FontBuilder underlineDouble() {
        this.underline = (byte)2;
        return this;
    }

    protected void setColor(Font font) {
        if (font instanceof XSSFFont) {
            XSSFFont xssfFont = (XSSFFont)font;
            XSSFColor colorInternal = new XSSFColor(this.color);
            xssfFont.setColor(colorInternal);
        } else if (font instanceof HSSFFont) {
            byte blue;
            byte green;
            byte red;
            HSSFFont hssfFont = (HSSFFont)font;
            HSSFPalette customPalette = ((HSSFWorkbook)this.workbook).getCustomPalette();
            HSSFColor colorInternal = customPalette.findColor(red = (byte)this.color.getRed(), green = (byte)this.color.getGreen(), blue = (byte)this.color.getBlue());
            if (null == colorInternal) {
                if (this.colorIdx < 0) {
                    throw new IllegalArgumentException("no more free color index");
                }
                short s = this.colorIdx;
                this.colorIdx = (short)(s - 1);
                customPalette.setColorAtIndex(s, red, green, blue);
                colorInternal = customPalette.findColor(red, green, blue);
            }
            hssfFont.setColor(colorInternal.getIndex());
        }
    }

    public Font build() {
        Font font = this.workbook.createFont();
        if (this.size > 0) {
            font.setFontHeightInPoints(this.size);
        }
        font.setBold(this.bold);
        font.setItalic(this.italic);
        font.setStrikeout(this.strikeout);
        if (this.underline > 0) {
            font.setUnderline(this.underline);
        }
        if (null != this.name) {
            font.setFontName(this.name);
        }
        if (null != this.color) {
            this.setColor(font);
        }
        return font;
    }

    public void reset() {
        this.color = null;
        this.size = (short)-1;
        this.name = null;
        this.italic = false;
        this.strikeout = false;
        this.bold = false;
        this.underline = (byte)-1;
    }
}

