/*
 * Decompiled with CFR 0.152.
 */
package org.appng.tools.poi;

import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.appng.tools.poi.Border;

public class Borders {
    private Border left;
    private Border right;
    private Border top;
    private Border bottom;

    public Borders() {
    }

    public Borders(BorderStyle left, BorderStyle right, BorderStyle top, BorderStyle bottom) {
        this.left(left);
        this.right(right);
        this.top(top);
        this.bottom(bottom);
    }

    public Border left() {
        return this.left;
    }

    public Border right() {
        return this.right;
    }

    public Border top() {
        return this.top;
    }

    public Border bottom() {
        return this.bottom;
    }

    public void applyTo(CellStyle cellStyle) {
        this.applyBorder(cellStyle, this.left);
        this.applyBorder(cellStyle, this.right);
        this.applyBorder(cellStyle, this.top);
        this.applyBorder(cellStyle, this.bottom);
    }

    private void applyBorder(CellStyle cellStyle, Border border) {
        if (null != border) {
            border.applyTo(cellStyle);
        }
    }

    private Border getBorder(Border.BorderLocation location, BorderStyle style) {
        if (null != style) {
            return new Border(location, style);
        }
        return new Border(location, BorderStyle.NONE);
    }

    public Borders left(BorderStyle style) {
        this.left = this.getBorder(Border.BorderLocation.LEFT, style);
        return this;
    }

    public Borders right(BorderStyle style) {
        this.right = this.getBorder(Border.BorderLocation.RIGHT, style);
        return this;
    }

    public Borders top(BorderStyle style) {
        this.top = this.getBorder(Border.BorderLocation.TOP, style);
        return this;
    }

    public Borders bottom(BorderStyle style) {
        this.bottom = this.getBorder(Border.BorderLocation.BOTTOM, style);
        return this;
    }

    public String toString() {
        return this.left + ", " + this.right + ", " + this.top + ", " + this.bottom;
    }

    public static class BorderBuilder {
        private Borders borders = new Borders();

        public BorderBuilder left(BorderStyle style) {
            this.borders.left(style);
            return this;
        }

        public BorderBuilder right(BorderStyle style) {
            this.borders.right(style);
            return this;
        }

        public BorderBuilder top(BorderStyle style) {
            this.borders.top(style);
            return this;
        }

        public BorderBuilder bottom(BorderStyle style) {
            this.borders.bottom(style);
            return this;
        }

        public Borders build() {
            return this.borders;
        }
    }
}

