/*
 * Decompiled with CFR 0.152.
 */
package org.appng.tools.image;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.lang3.StringUtils;
import org.appng.tools.RandomUtil;
import org.im4java.core.ConvertCmd;
import org.im4java.core.IM4JavaException;
import org.im4java.core.IMOperation;
import org.im4java.core.Operation;
import org.im4java.process.OutputConsumer;
import org.im4java.process.Pipe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Captcha {
    private static final Logger LOGGER = LoggerFactory.getLogger(Captcha.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getCaptcha(OutputStream out, int minRandom, int maxRandom, File backgroundPath, String gravity, String font, Integer pointsize, String color, String imageFormat) {
        String calc;
        int n1 = RandomUtil.randomValueBetween(minRandom, maxRandom);
        int oper = RandomUtil.randomValueBetween(0, 2);
        int n2 = RandomUtil.randomValueBetween(minRandom, maxRandom);
        for (int i = 0; i <= n1 + oper * 7; ++i) {
            n2 = RandomUtil.randomValueBetween(minRandom, maxRandom);
        }
        Integer result = null;
        if (oper == 0) {
            calc = n1 + " + " + n2;
            result = n1 + n2;
        } else if (n1 > n2) {
            calc = n1 + " - " + n2;
            result = n1 - n2;
        } else {
            calc = n2 + " - " + n1;
            result = n2 - n1;
        }
        IMOperation op = new IMOperation();
        op.addImage();
        op.gravity(gravity);
        if (StringUtils.isNotBlank((CharSequence)font)) {
            op.font(font);
        }
        op.pointsize(pointsize);
        if (StringUtils.isNotBlank((CharSequence)color)) {
            op.fill(color);
        }
        op.annotate(Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), calc + " = ");
        op.addImage(new String[]{imageFormat + ":-"});
        Pipe pipeOut = new Pipe(null, out);
        ConvertCmd cmd = new ConvertCmd();
        cmd.setOutputConsumer((OutputConsumer)pipeOut);
        try {
            cmd.run((Operation)op, new Object[]{backgroundPath.getAbsolutePath()});
        }
        catch (IOException e) {
            LOGGER.error("IOException", (Throwable)e);
        }
        catch (InterruptedException e) {
            LOGGER.error("InterruptedException", (Throwable)e);
        }
        catch (IM4JavaException e) {
            LOGGER.error("IM4JavaException", (Throwable)e);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {}
        }
        return result;
    }
}

