/*
 * Decompiled with CFR 0.152.
 */
package org.appng.tools.image;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.FileImageInputStream;
import org.apache.commons.io.FilenameUtils;
import org.appng.tools.file.MagicByteCheck;
import org.appng.tools.image.ImageMetaData;
import org.im4java.core.ConvertCmd;
import org.im4java.core.IM4JavaException;
import org.im4java.core.IMOperation;
import org.im4java.core.ImageCommand;
import org.im4java.core.Operation;
import org.im4java.process.ArrayListOutputConsumer;
import org.im4java.process.OutputConsumer;
import org.im4java.process.ProcessStarter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageProcessor.class);
    private final File sourceFile;
    private final File targetFile;
    private final ImageCommand cmd;
    private final IMOperation op;

    public static boolean isImageMagickPresent(File imageMagickPath) {
        if (null != imageMagickPath) {
            ImageProcessor.setGlobalSearchPath(imageMagickPath);
        }
        try {
            ConvertCmd convertCmd = new ConvertCmd();
            ArrayListOutputConsumer out = new ArrayListOutputConsumer();
            convertCmd.setOutputConsumer((OutputConsumer)out);
            convertCmd.run((Operation)new IMOperation().version(), new Object[0]);
            String version = (String)out.getOutput().get(0);
            LOGGER.info(version);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("error while retrieving ImageMagickVersion", (Throwable)e);
            return false;
        }
    }

    public ImageProcessor(File imageMagickPath, File sourceFile, File targetFile) {
        if (null != imageMagickPath) {
            ImageProcessor.setGlobalSearchPath(imageMagickPath);
        }
        this.sourceFile = sourceFile;
        this.targetFile = targetFile;
        this.cmd = new ConvertCmd();
        this.op = new IMOperation();
        this.op.addImage();
    }

    public ImageProcessor(File imageMagickPath, File sourceFile, File targetFile, boolean checkMagicBytes) throws IOException {
        this(imageMagickPath, sourceFile, targetFile, true, checkMagicBytes);
    }

    public ImageProcessor(File sourceFile, File targetFile) {
        this(null, sourceFile, targetFile);
    }

    public ImageProcessor(File sourceFile, File targetFile, boolean checkMagicBytes) throws IOException {
        this(null, sourceFile, targetFile, false, checkMagicBytes);
    }

    private ImageProcessor(File imageMagickPath, File sourceFile, File targetFile, boolean setGlobalSearchPath, boolean checkMagicBytes) throws IOException {
        if (setGlobalSearchPath) {
            ImageProcessor.setGlobalSearchPath(imageMagickPath);
        }
        this.sourceFile = sourceFile;
        this.targetFile = targetFile;
        this.cmd = new ConvertCmd();
        this.op = new IMOperation();
        if (checkMagicBytes) {
            this.checkSourceFileContentType();
        }
        this.op.addImage();
    }

    private void checkSourceFileContentType() throws IOException {
        String extensionByMagicBytes;
        String extension = FilenameUtils.getExtension((String)this.sourceFile.getName());
        if (!extension.equals(extensionByMagicBytes = MagicByteCheck.getExtensionByMagicBytes(this.sourceFile))) {
            throw new IOException(String.format("File type detected by magic byte (%s) is not identical with file extension for file %s", extensionByMagicBytes, this.sourceFile.getAbsolutePath()));
        }
    }

    public static void setGlobalSearchPath(File imageMagickPath) {
        ProcessStarter.setGlobalSearchPath((String)imageMagickPath.getAbsolutePath());
    }

    public ImageMetaData getMetaData() throws IOException {
        FileImageInputStream input = new FileImageInputStream(this.sourceFile);
        Iterator<ImageReader> imageReaders = ImageIO.getImageReaders(input);
        if (imageReaders.hasNext()) {
            ImageReader reader = imageReaders.next();
            reader.setInput(input);
            ImageMetaData imageMetaData = new ImageMetaData(this.sourceFile, reader.getWidth(0), reader.getHeight(0));
            input.close();
            return imageMetaData;
        }
        input.close();
        throw new IOException("no ImageReader found for " + this.sourceFile.getAbsolutePath());
    }

    public ImageProcessor rotate(int degrees) {
        this.op.rotate(Double.valueOf(degrees));
        return this;
    }

    public ImageProcessor resize(int targetWidth, int targetHeight, boolean scaleUp) {
        if (!scaleUp) {
            ImageMetaData metaData;
            try {
                metaData = this.getMetaData();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("error while reading " + this.sourceFile, e);
            }
            int sourceWidth = metaData.getWidth();
            int sourceHeight = metaData.getHeight();
            targetWidth = targetWidth > sourceWidth ? sourceWidth : targetWidth;
            targetHeight = targetHeight > sourceHeight ? sourceHeight : targetHeight;
        }
        this.resize(targetWidth, targetHeight);
        return this;
    }

    public ImageProcessor resize(int targetWidth, int targetHeight) {
        if (targetWidth > 0 && targetHeight > 0) {
            this.op.resize(Integer.valueOf(targetWidth), Integer.valueOf(targetHeight));
        }
        return this;
    }

    public ImageProcessor quality(double quality) {
        this.op.quality(Double.valueOf(quality));
        return this;
    }

    public ImageProcessor strip() {
        this.op.strip();
        return this;
    }

    public ImageProcessor autoCrop(int positionWidth, int positionHeight, int sourceWidth, int sourceHeight) {
        return this.autoCrop(positionWidth, positionHeight, sourceWidth, sourceHeight, 0, 0);
    }

    public ImageProcessor autoCrop(int positionWidth, int positionHeight, int variantWidth, int variantHeight, int variantOffsetWidth, int variantOffsetHeight) {
        int offsetHeight;
        int offsetWidth;
        int uncroppedPositionHeight;
        int uncroppedPositionWidth;
        double variantFactor = (double)variantWidth / (double)variantHeight;
        double positionFactor = (double)positionWidth / (double)positionHeight;
        if (variantFactor > positionFactor) {
            uncroppedPositionWidth = Math.round((float)(variantHeight * positionWidth) / (float)positionHeight);
            uncroppedPositionHeight = variantHeight;
            offsetWidth = variantOffsetWidth + Math.round((float)(variantWidth - uncroppedPositionWidth) / 2.0f);
            offsetHeight = variantOffsetHeight;
        } else {
            uncroppedPositionWidth = variantWidth;
            uncroppedPositionHeight = Math.round((float)(positionHeight * variantWidth) / (float)positionWidth);
            offsetWidth = variantOffsetWidth;
            offsetHeight = variantOffsetHeight + Math.round((float)(variantHeight - uncroppedPositionHeight) / 2.0f);
        }
        this.crop(uncroppedPositionWidth, uncroppedPositionHeight, offsetWidth, offsetHeight);
        return this.resize(positionWidth, positionHeight);
    }

    public ImageProcessor crop(int targetWidth, int targetHeight, int offsetWidth, int offsetHeight) {
        this.op.crop(Integer.valueOf(targetWidth), Integer.valueOf(targetHeight), Integer.valueOf(offsetWidth), Integer.valueOf(offsetHeight));
        return this;
    }

    public File getImage() throws IOException {
        this.op.interlace("Plane");
        this.op.addImage();
        try {
            this.cmd.run((Operation)this.op, new Object[]{this.sourceFile.getAbsolutePath(), this.targetFile.getAbsolutePath()});
        }
        catch (InterruptedException ex) {
            throw new IOException(ex);
        }
        catch (IM4JavaException ex) {
            throw new IOException(ex);
        }
        return this.targetFile;
    }

    public ImageProcessor fitToWidthAndHeight(int maxwidth, int maxHeight) throws IOException {
        ImageMetaData metaData = this.getMetaData();
        int width = metaData.getWidth();
        int height = metaData.getHeight();
        float ratioWidth = (float)maxwidth / (float)width;
        float ratioHeight = (float)maxHeight / (float)height;
        float ratio = Math.min(ratioWidth, ratioHeight);
        int scaledWidth = Math.round((float)width * ratio);
        int scaledHeight = Math.round((float)height * ratio);
        return this.resize(scaledWidth, scaledHeight);
    }

    public ImageProcessor fitToWidth(Integer maxWidth) throws IOException {
        ImageMetaData metaData = this.getMetaData();
        int width = metaData.getWidth();
        int height = metaData.getHeight();
        if (width > maxWidth) {
            width = maxWidth;
            height = Math.round((float)maxWidth.intValue() / (float)width * (float)height);
        }
        return this.resize(width, height);
    }

    public ImageProcessor fitToHeight(Integer maxHeight) throws IOException {
        ImageMetaData metaData = this.getMetaData();
        int width = metaData.getWidth();
        int height = metaData.getHeight();
        if (height > maxHeight) {
            height = maxHeight;
            width = Math.round((float)maxHeight.intValue() / (float)height * (float)width);
        }
        return this.resize(width, height);
    }

    public IMOperation getOp() {
        return this.op;
    }
}

