/*
 * Decompiled with CFR 0.152.
 */
package org.appng.tools.ui;

import java.text.Normalizer;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class StringNormalizer {
    public static final Pattern NON_PRINTABLE_CHARACTER = Pattern.compile("[\\p{Cc}&&[^\\t\\r\\n]]");
    private static final char[] charsToRemove = new char[]{'!', '\"', '\u00a7', '$', '%', '&', '/', '(', ')', '=', '?', '\u00b4', '{', '[', ']', '}', '\\', '`', '+', '-', '*', '%', ':', ',', ';', '<', '>', '\u00b0', '^', '#', '~', '\'', '|'};
    private static final String NORMALIZE_PATTERN = "\\p{IsM}+";

    public static final String normalize(String input) {
        String[] searchList = new String[]{"\u00e4", "\u00c4", "\u00f6", "\u00d6", "\u00fc", "\u00dc", "\u00df"};
        String[] replacementList = new String[]{"ae", "Ae", "oe", "Oe", "ue", "Ue", "ss"};
        String replaced = StringUtils.replaceEachRepeatedly((String)input, (String[])searchList, (String[])replacementList);
        String normalizedString = Normalizer.normalize(replaced, Normalizer.Form.NFD);
        Pattern pattern = Pattern.compile(NORMALIZE_PATTERN);
        String result = pattern.matcher(normalizedString).replaceAll("");
        for (char c : charsToRemove) {
            result = StringUtils.replaceChars((String)result, (String)String.valueOf(c), (String)"");
        }
        return result;
    }

    public static String removeNonPrintableCharacters(String value) {
        return StringNormalizer.replaceNonPrintableCharacters(value, "");
    }

    public static String replaceNonPrintableCharacters(String value, String replacement) {
        if (null != value) {
            return NON_PRINTABLE_CHARACTER.matcher(value).replaceAll(replacement);
        }
        return value;
    }
}

