/*
 * Decompiled with CFR 0.152.
 */
package org.appng.tools.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;

public class PropertyConstantCreator {
    public static void main(String[] args) throws IOException {
        if (args.length < 3) {
            throw new IllegalArgumentException("at least 3 parameters needed: filePath* targetClass* outFolder* [charset]");
        }
        String filePath = args[0];
        String targetClass = args[1];
        String outfolder = args[2];
        String charSet = StandardCharsets.UTF_8.name();
        if (args.length == 4) {
            charSet = args[3];
        }
        if (!targetClass.matches("([a-zA-Z]+[0-9]*)+(\\.[a-zA-Z]+[0-9]*)*")) {
            throw new IllegalArgumentException("not a valid classname: " + targetClass);
        }
        Properties props = new Properties();
        props.load(new InputStreamReader((InputStream)new FileInputStream(filePath), charSet));
        int pckg = targetClass.lastIndexOf(".");
        String lineBreak = System.lineSeparator();
        StringBuilder sb = new StringBuilder();
        if (pckg > 0) {
            sb.append("package " + targetClass.substring(0, pckg) + ";");
            sb.append(lineBreak);
            sb.append(lineBreak);
        }
        sb.append("public class " + targetClass.substring(pckg + 1) + " {");
        sb.append(lineBreak);
        sb.append(lineBreak);
        TreeSet<Object> keySet = new TreeSet<Object>(props.keySet());
        for (Object e : keySet) {
            String key = (String)e;
            sb.append("\t/** " + props.getProperty(key).replace("*/", "*&#47;") + " */" + lineBreak);
            sb.append("\tpublic static final String ");
            String constantName = key.replace('-', '_').replace('.', '_');
            String[] tokens = StringUtils.splitByCharacterTypeCamelCase((String)constantName);
            for (int i = 0; i < tokens.length; ++i) {
                String s = tokens[i];
                if ("_".equals(s)) continue;
                if (i > 0) {
                    sb.append("_");
                }
                sb.append(s.toUpperCase());
            }
            sb.append(" = \"" + key + "\";");
            sb.append(lineBreak);
        }
        sb.append(lineBreak);
        sb.append("}");
        String fileName = targetClass.replace('.', '/') + ".java";
        File file = new File(new File(outfolder).getAbsoluteFile(), fileName);
        file.getParentFile().mkdirs();
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(sb.toString().getBytes(StandardCharsets.UTF_8));
        }
    }
}

