/*
 * Decompiled with CFR 0.152.
 */
package org.appng.tools.ui;

import org.appng.tools.ui.Chunk;

public class Pagination {
    protected int chunk;
    protected String chunkname;
    protected int chunksize;
    protected int nextchunk;
    protected int previouschunk;
    protected int firstchunk;
    protected int lastchunk;
    protected int hits;
    protected int maxhits;
    protected int hitRangeStart;
    protected int hitRangeEnd;

    public Pagination(Chunk chunkParam) {
        this.chunksize = chunkParam.getChunkSize();
        this.chunk = chunkParam.getChunk();
        this.chunkname = chunkParam.getChunkName();
    }

    public static final Pagination getPagination(int hits, int maxHits, Chunk chunkParam) {
        Pagination pagination = new Pagination(chunkParam);
        pagination.calculatePagination(hits, maxHits);
        return pagination;
    }

    public void calculatePagination(int hits, int maxHits) {
        int hitRangeStart;
        int hitRangeEnd;
        int firstchunk = 0;
        if (this.chunksize == 0) {
            this.chunksize = hits;
        }
        int lastchunk = Pagination.getLastChunk(hits, this.chunksize);
        if (hits <= this.chunksize) {
            lastchunk = firstchunk;
        }
        if (this.chunk < firstchunk || this.chunk > lastchunk) {
            this.chunk = firstchunk;
        }
        int nextchunk = lastchunk;
        if (this.chunk < lastchunk) {
            nextchunk = this.chunk + 1;
        }
        int previouschunk = 0;
        if (this.chunk > 0) {
            previouschunk = this.chunk - 1;
        }
        if (this.chunkname == null || this.chunkname.equals("")) {
            this.chunkname = "chunk";
        }
        if ((hitRangeEnd = (hitRangeStart = this.chunk * this.chunksize) - 1 + this.chunksize) >= hits) {
            hitRangeEnd = hits - 1;
        }
        this.setChunk(this.chunk);
        this.setChunkname(this.chunkname);
        this.setChunksize(this.chunksize);
        this.setHitRangeStart(hitRangeStart);
        this.setHitRangeEnd(hitRangeEnd);
        this.setFirstchunk(firstchunk);
        this.setLastchunk(lastchunk);
        this.setPreviouschunk(previouschunk);
        this.setNextchunk(nextchunk);
        this.setHits(hits);
        this.setMaxhits(maxHits);
    }

    public int getChunk() {
        return this.chunk;
    }

    public void setChunk(int chunk) {
        this.chunk = chunk;
    }

    public String getChunkname() {
        return this.chunkname;
    }

    public void setChunkname(String chunkname) {
        this.chunkname = chunkname;
    }

    public int getChunksize() {
        return this.chunksize;
    }

    public void setChunksize(int chunksize) {
        this.chunksize = chunksize;
    }

    public int getNextchunk() {
        return this.nextchunk;
    }

    public void setNextchunk(int nextchunk) {
        this.nextchunk = nextchunk;
    }

    public int getPreviouschunk() {
        return this.previouschunk;
    }

    public void setPreviouschunk(int previouschunk) {
        this.previouschunk = previouschunk;
    }

    public int getFirstchunk() {
        return this.firstchunk;
    }

    public void setFirstchunk(int firstchunk) {
        this.firstchunk = firstchunk;
    }

    public int getLastchunk() {
        return this.lastchunk;
    }

    public void setLastchunk(int lastchunk) {
        this.lastchunk = lastchunk;
    }

    public int getHits() {
        return this.hits;
    }

    public void setHits(int hits) {
        this.hits = hits;
    }

    public int getMaxhits() {
        return this.maxhits;
    }

    public void setMaxhits(int maxhits) {
        this.maxhits = maxhits;
    }

    public int getHitRangeStart() {
        return this.hitRangeStart;
    }

    public void setHitRangeStart(int hitRangeStart) {
        this.hitRangeStart = hitRangeStart;
    }

    public int getHitRangeEnd() {
        return this.hitRangeEnd;
    }

    public void setHitRangeEnd(int hitRangeEnd) {
        this.hitRangeEnd = hitRangeEnd;
    }

    private static int getLastChunk(int hits, int chunksize) {
        if (chunksize > 0) {
            return hits / chunksize + (hits % chunksize == 0 ? 0 : 1) - 1;
        }
        return 0;
    }
}

