/*
 * Decompiled with CFR 0.152.
 */
package org.appng.tools.file;

import com.j256.simplemagic.ContentInfoUtil;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MagicByteCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(MagicByteCheck.class);
    private static final ContentInfoUtil CONTENT_INFO_UTIL = new ContentInfoUtil();

    public static boolean compareFileExtensionWithMagicBytes(File sourceFile) {
        StopWatch sw = new StopWatch();
        sw.start();
        String magicExtension = MagicByteCheck.getExtensionByMagicBytes(sourceFile);
        String fileNameExtension = MagicByteCheck.normalizeFileExtension(FilenameUtils.getExtension((String)sourceFile.getName()));
        boolean matches = fileNameExtension.equalsIgnoreCase(magicExtension);
        if (!matches) {
            LOGGER.debug("File type detected by magic byte ({}) is not identical with file extension for file {}", new Object[]{magicExtension, fileNameExtension, sourceFile.getAbsolutePath()});
        }
        sw.stop();
        LOGGER.trace(sw.toString());
        return matches;
    }

    public static String getExtensionByMagicBytes(File file) {
        try {
            String[] fileExtensions = CONTENT_INFO_UTIL.findMatch(file).getFileExtensions();
            return null == fileExtensions ? null : MagicByteCheck.normalizeFileExtension(fileExtensions[0]);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static String normalizeFileExtension(String extension) {
        return extension.equalsIgnoreCase("jpeg") ? "jpg" : extension;
    }
}

