/*
 * Decompiled with CFR 0.152.
 */
package org.appng.tools.markup;

import java.io.StringWriter;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XML {
    private static final Logger LOGGER = LoggerFactory.getLogger(XML.class);

    public static String transform(Source xmlSource, Source xsltSource) {
        String result = "";
        ErrorListener errorListener = XML.getErrorListener();
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            tf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            tf.setErrorListener(errorListener);
            Templates templates = tf.newTemplates(xsltSource);
            Transformer transformer = templates.newTransformer();
            transformer.setErrorListener(errorListener);
            StringWriter output = new StringWriter();
            transformer.transform(xmlSource, new StreamResult(output));
            result = output.toString();
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        return result;
    }

    private static ErrorListener getErrorListener() {
        return new ErrorListener(){

            @Override
            public void warning(TransformerException te) throws TransformerException {
                LOGGER.warn(te.getMessageAndLocation(), (Throwable)te);
            }

            @Override
            public void fatalError(TransformerException te) throws TransformerException {
                LOGGER.error(te.getMessageAndLocation(), (Throwable)te);
            }

            @Override
            public void error(TransformerException te) throws TransformerException {
                LOGGER.error(te.getMessageAndLocation(), (Throwable)te);
            }
        };
    }

    public static String transform(Source xmlSource, String xsltFile) {
        return XML.transform(xmlSource, new StreamSource(xsltFile));
    }
}

