/*
 * Decompiled with CFR 0.152.
 */
package org.appng.tools.os;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public enum OperatingSystem {
    LINUX("linux", "nix"),
    WINDOWS("windows"),
    MACOSX("mac"),
    OTHER("");

    private String[] searchString;
    private static final List<OperatingSystem> operatingSystems;

    private OperatingSystem(String ... searchString) {
        this.searchString = searchString;
    }

    public static OperatingSystem detect() {
        return OperatingSystem.detect(System.getProperty("os.name"));
    }

    static OperatingSystem detect(String osName) {
        String name = null != osName ? osName.toLowerCase() : "";
        return operatingSystems.stream().filter(os -> StringUtils.containsAny((CharSequence)name, (CharSequence[])os.searchString)).findFirst().orElse(OTHER);
    }

    public static boolean isLinux() {
        return LINUX.equals((Object)OperatingSystem.detect());
    }

    public static boolean isMac() {
        return MACOSX.equals((Object)OperatingSystem.detect());
    }

    public static boolean isWindows() {
        return WINDOWS.equals((Object)OperatingSystem.detect());
    }

    public static boolean isOther() {
        return OTHER.equals((Object)OperatingSystem.detect());
    }

    static boolean isOs(OperatingSystem os) {
        return os.equals((Object)OperatingSystem.detect());
    }

    static {
        operatingSystems = Arrays.asList(OperatingSystem.values());
    }
}

