/*
 * Decompiled with CFR 0.152.
 */
package org.appng.tools.zipcode;

import org.appng.tools.zipcode.DefaultZipCodeValidator;
import org.appng.tools.zipcode.GermanyZipCodeValidator;
import org.appng.tools.zipcode.ZipCodeCountry;
import org.appng.tools.zipcode.ZipCodeValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipCodeValidatorFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZipCodeValidatorFactory.class);

    public static ZipCodeValidator getInstance(ZipCodeCountry country) {
        switch (country) {
            case DE: {
                return new GermanyZipCodeValidator();
            }
        }
        return new DefaultZipCodeValidator();
    }

    public static ZipCodeValidator getInstance(String country) {
        try {
            if (null != country) {
                return ZipCodeValidatorFactory.getInstance(ZipCodeCountry.valueOf(country.toUpperCase()));
            }
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn(e.getMessage());
        }
        return new DefaultZipCodeValidator();
    }
}

