/*
 * Copyright 2011-2021 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.appng.tools.zipcode;

import lombok.extern.slf4j.Slf4j;

/**
 * TODO insert description
 * 
 * @author Matthias Herlitzius
 */
@Slf4j
public class ZipCodeValidatorFactory {

	public static ZipCodeValidator getInstance(ZipCodeCountry country) {
		switch (country) {
		case DE:
			return new GermanyZipCodeValidator();
		}
		return new DefaultZipCodeValidator();
	}

	public static ZipCodeValidator getInstance(String country) {
		try {
			if (null != country) {
				return getInstance(ZipCodeCountry.valueOf(country.toUpperCase()));
			}
		} catch (IllegalArgumentException e) {
			LOGGER.warn(e.getMessage());
		}
		return new DefaultZipCodeValidator();
	}

}
