/*
 * Decompiled with CFR 0.152.
 */
package org.appng.upngizr.controller;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.Container;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.appng.upngizr.controller.UpNGizr;
import org.appng.upngizr.controller.Updater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestClientException;

@RestController
public class Updater {
    private static final Logger log = LoggerFactory.getLogger(Updater.class);
    private static final String BUILD = "{build}";
    private static final String VERSION = "{version}";
    private static final String APPNG_APPLICATION = String.format("appng-application-%s.war", "{version}");
    private static final String APPNGIZER_APPLICATION = String.format("appng-appngizer-%s.war", "{version}");
    private static final String INIT_PARAM_BLOCK_REMOTE_IPS = "blockRemoteIPs";
    private static final String INIT_PARAM_BUILD_REPOSITORY = "buildRepository";
    private static final String INIT_PARAM_REPLACE_BIN = "replaceBin";
    private static final String INIT_PARAM_REPLACE_PLATFORMCONTEXT = "replacePlatformContext";
    private static final String INIT_PARAM_REPLACE_WEB_XML = "replaceWebXml";
    private static final String INIT_PARAM_USE_FQDN = "useFQDN";
    private static final String WEB_INF = "WEB-INF/";
    private static final String META_INF = "META-INF/";
    private static final String WEB_INF_CLASSES = "WEB-INF/classes/";
    private static final String WEB_INF_LIB = "WEB-INF/lib/";
    private ServletContext context;
    private String buildRepository = String.format("https://appng.org/appng/builds/%s/", "{build}");
    private boolean replacePlatformContext = true;
    private boolean replaceWebXml = true;
    private boolean replaceBin = false;
    private boolean blockRemoteIps = true;
    private String serverName;
    private boolean useFQDN = false;
    private List<String> localAdresses = new ArrayList();
    private AtomicBoolean isUpdateRunning = new AtomicBoolean(false);
    private AtomicReference<Double> completed = new AtomicReference<Double>(0.0);
    private AtomicReference<String> status = new AtomicReference<String>("Starting update");

    @Autowired
    public Updater(ServletContext context) {
        this.context = context;
        if (null != context.getInitParameter(INIT_PARAM_BUILD_REPOSITORY)) {
            this.buildRepository = context.getInitParameter(INIT_PARAM_BUILD_REPOSITORY);
        }
        if (null != context.getInitParameter(INIT_PARAM_REPLACE_PLATFORMCONTEXT)) {
            this.replacePlatformContext = Boolean.valueOf(context.getInitParameter(INIT_PARAM_REPLACE_PLATFORMCONTEXT));
        }
        if (null != context.getInitParameter(INIT_PARAM_REPLACE_WEB_XML)) {
            this.replaceWebXml = Boolean.valueOf(context.getInitParameter(INIT_PARAM_REPLACE_WEB_XML));
        }
        if (null != context.getInitParameter(INIT_PARAM_REPLACE_BIN)) {
            this.replaceBin = Boolean.valueOf(context.getInitParameter(INIT_PARAM_REPLACE_BIN));
        }
        if (null != context.getInitParameter(INIT_PARAM_BLOCK_REMOTE_IPS)) {
            this.blockRemoteIps = Boolean.valueOf(context.getInitParameter(INIT_PARAM_BLOCK_REMOTE_IPS));
        }
        if (null != context.getInitParameter(INIT_PARAM_USE_FQDN)) {
            this.useFQDN = Boolean.valueOf(context.getInitParameter(INIT_PARAM_USE_FQDN));
        }
        log.info("{}: {}", (Object)INIT_PARAM_BUILD_REPOSITORY, (Object)this.buildRepository);
        log.info("{}: {}", (Object)INIT_PARAM_REPLACE_PLATFORMCONTEXT, (Object)this.replacePlatformContext);
        log.info("{}: {}", (Object)INIT_PARAM_REPLACE_WEB_XML, (Object)this.replaceWebXml);
        log.info("{}: {}", (Object)INIT_PARAM_REPLACE_BIN, (Object)this.replaceBin);
        log.info("{}: {}", (Object)INIT_PARAM_BLOCK_REMOTE_IPS, (Object)this.blockRemoteIps);
        log.info("{}: {}", (Object)INIT_PARAM_USE_FQDN, (Object)this.useFQDN);
        if (this.blockRemoteIps) {
            try {
                Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
                while (networkInterfaces.hasMoreElements()) {
                    NetworkInterface networkInterface = networkInterfaces.nextElement();
                    Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                    while (inetAddresses.hasMoreElements()) {
                        String hostAddress;
                        int idx = (hostAddress = inetAddresses.nextElement().getHostAddress()).indexOf(37);
                        this.localAdresses.add(hostAddress.substring(0, idx > 0 ? idx : hostAddress.length()));
                    }
                }
                log.info("Allowed local addresses: {}", (Object)StringUtils.collectionToCommaDelimitedString((Collection)this.localAdresses));
            }
            catch (SocketException e) {
                log.error("error retrieving networkinterfaces", (Throwable)e);
            }
        }
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            String canonicalHostName = localHost.getCanonicalHostName().toLowerCase();
            if (this.useFQDN) {
                this.serverName = canonicalHostName;
                log.info("serverName: {}", (Object)this.serverName);
            }
            log.info("FQDN: {}", (Object)canonicalHostName);
        }
        catch (UnknownHostException e) {
            log.error("Error retrieving local host name", (Throwable)e);
        }
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/update/start/{version:.+}"}, produces={"text/html"})
    public ResponseEntity<String> getStartPage(@PathVariable(value="version") String version, @RequestParam(required=false, defaultValue="") String onSuccess, HttpServletRequest request) throws IOException, URISyntaxException {
        if (this.isBlocked(request) || this.isUpdateRunning.get()) {
            return this.forbidden();
        }
        Resource artifactResource = this.getArtifact(version, APPNG_APPLICATION);
        if (!artifactResource.exists()) {
            return this.notFound(artifactResource);
        }
        ClassPathResource resource = new ClassPathResource("updater.html");
        String content = IOUtils.toString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8);
        int serverPort = request.getServerPort();
        if (null == this.serverName) {
            this.serverName = request.getServerName();
        }
        String uppNGizrBase = String.format(serverPort == 80 ? "//%s/upNGizr" : "//%s:%s/upNGizr", this.serverName, serverPort);
        content = content.replace("<target>", onSuccess).replace("<path>", uppNGizrBase);
        content = content.replace("<version>", version).replace("<button>", "Update to " + version);
        return new ResponseEntity((Object)content, HttpStatus.OK);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/update/status"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Status> getStatus() {
        Status status = new Status(this, (String)this.status.get(), ((Double)this.completed.get()).doubleValue());
        return new ResponseEntity((Object)status, HttpStatus.OK);
    }

    @RequestMapping(path={"/checkVersionAvailable/{version:.+}"}, method={RequestMethod.GET})
    public ResponseEntity<Void> checkVersionAvailable(@PathVariable(value="version") String version, HttpServletRequest request) throws IOException {
        if (this.isBlocked(request)) {
            return this.forbidden();
        }
        Resource resource = this.getArtifact(version, APPNG_APPLICATION);
        if (!resource.exists()) {
            return this.notFound(resource);
        }
        return new ResponseEntity(HttpStatus.OK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(path={"/update/{version:.+}"}, produces={"text/plain"}, method={RequestMethod.POST})
    public ResponseEntity<String> updateAppng(@PathVariable(value="version") String version, @RequestParam(required=false) String onSuccess, HttpServletRequest request) {
        if (this.isBlocked(request) || this.isUpdateRunning.get()) {
            return this.forbidden();
        }
        this.isUpdateRunning.set(true);
        try {
            Resource appNGArchive = this.getArtifact(version, APPNG_APPLICATION);
            if (!appNGArchive.exists()) {
                ResponseEntity responseEntity = this.notFound(appNGArchive);
                return responseEntity;
            }
            this.status.set("Stopping appNG");
            this.completed.set(5.0);
            this.getHost().setAutoDeploy(false);
            Container appNGizerContext = this.stopContext(this.getAppNGizerContext());
            Container appNGContext = this.stopContext(this.getAppNGContext());
            this.completed.set(30.0);
            this.updateAppNG(appNGArchive, UpNGizr.appNGHome);
            this.status.set("Starting appNG");
            this.completed.set(81.0);
            log.info((String)this.status.get());
            ExecutorService contextStarter = Executors.newFixedThreadPool(1, (ThreadFactory)new /* Unavailable Anonymous Inner Class!! */);
            Future<Void> startAppNG = contextStarter.submit(() -> {
                this.startContext(appNGContext);
                return null;
            });
            Long duration = this.waitFor(startAppNG, 95.0, 3);
            log.info("Started appNG in {} seconds.", (Object)(duration / 1000L));
            if (null != appNGizerContext) {
                Future<Void> startAppNGizer = contextStarter.submit(() -> {
                    this.updateAppNGizer(this.getArtifact(version, APPNGIZER_APPLICATION), UpNGizr.appNGizerHome);
                    this.status.set("Starting appNGizer");
                    log.info((String)this.status.get());
                    this.startContext(appNGizerContext);
                    this.completed.set(98.0);
                    return null;
                });
                duration = this.waitFor(startAppNGizer, 98.0, 2);
                log.info("Started appNGizer in {} seconds.", (Object)(duration / 1000L));
            }
            contextStarter.shutdown();
            this.completed.set(100.0);
            String statusLink = StringUtils.isEmpty((Object)onSuccess) ? "" : String.format("<br/>Forwarding to<br/><a href=\"%s\">%s</a>", onSuccess, onSuccess);
            this.status.set("Update complete." + statusLink);
            ResponseEntity responseEntity = new ResponseEntity((Object)"OK", HttpStatus.OK);
            return responseEntity;
        }
        catch (Exception e) {
            log.error("error", (Throwable)e);
        }
        finally {
            this.isUpdateRunning.set(false);
        }
        return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
    }

    private Long waitFor(Future<Void> task, double startValue, int sleepSecond) throws InterruptedException, ExecutionException {
        long start = System.currentTimeMillis();
        while (!task.isDone()) {
            Thread.sleep(sleepSecond * 1000);
            if (((Double)this.completed.get()).compareTo(startValue) != -1) continue;
            this.completed.set((Double)this.completed.get() + 1.0);
        }
        return System.currentTimeMillis() - start;
    }

    private <T> ResponseEntity<T> forbidden() {
        return new ResponseEntity(HttpStatus.FORBIDDEN);
    }

    private <T> ResponseEntity<T> notFound(Resource resource) throws IOException {
        log.warn("{} does not exist!", (Object)resource.getURL());
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    private boolean isBlocked(HttpServletRequest request) {
        boolean isBlocked;
        log.info("Source: {}", (Object)request.getRemoteAddr());
        boolean bl = isBlocked = this.blockRemoteIps && !this.localAdresses.isEmpty() && !this.localAdresses.contains(request.getRemoteAddr());
        if (isBlocked) {
            log.info("remote address {} is not in list of allowed addresses ({})", (Object)request.getRemoteAddr(), (Object)StringUtils.collectionToDelimitedString((Collection)this.localAdresses, (String)" "));
        }
        return isBlocked;
    }

    private Resource getArtifact(String version, String filename) throws MalformedURLException {
        String build = version.endsWith("-SNAPSHOT") ? "snapshot" : "stable";
        String url = this.buildRepository.replace(BUILD, build).replace(VERSION, version) + filename.replace(VERSION, version);
        return new UrlResource(url);
    }

    private Container stopContext(Container context) {
        if (null != context) {
            try {
                context.stop();
                return context;
            }
            catch (LifecycleException e) {
                log.error("error stopping context", (Throwable)e);
            }
        }
        return null;
    }

    private void startContext(Container context) {
        if (null != context) {
            try {
                context.start();
            }
            catch (LifecycleException e) {
                log.error("error starting context", (Throwable)e);
            }
        }
    }

    protected void updateAppNG(Resource resource, String appNGHome) throws IOException, ZipException, FileNotFoundException {
        this.status.set(String.format("Downloading update %s", resource.getFilename()));
        long contentLength = resource.contentLength();
        long sizeMB = contentLength / 1024L / 1024L;
        log.info("reading {} MB from {}", (Object)sizeMB, (Object)resource.getDescription());
        long start = System.currentTimeMillis();
        InputStream is = resource.getInputStream();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] bytes = new byte[8192];
        int count = -1;
        long read = 0L;
        int progress = 0;
        while ((count = is.read(bytes, 0, bytes.length)) != -1) {
            os.write(bytes, 0, count);
            int currentProgress = (int)((double)(read += (long)count) / (double)contentLength * 100.0);
            if (progress != currentProgress && currentProgress % 5 == 0) {
                long readMB = read / 1024L / 1024L;
                log.info("retrieved {}/{} MB ({}%)", new Object[]{readMB, sizeMB, currentProgress});
                this.completed.set(30.0 + (double)currentProgress / 2.5);
                this.status.set(String.format("Downloaded " + readMB + " of " + sizeMB + "MB", new Object[0]));
            }
            progress = currentProgress;
        }
        System.err.println("");
        long duration = (System.currentTimeMillis() - start) / 1000L;
        log.debug("downloading {} MB took {}s ({}MB/s)", new Object[]{sizeMB, duration, sizeMB / (duration == 0L ? 1L : duration)});
        byte[] data = os.toByteArray();
        Path warArchive = Files.createTempFile(null, null, new FileAttribute[0]);
        IOUtils.write((byte[])data, (OutputStream)new FileOutputStream(warArchive.toFile()));
        File libFolder = new File(appNGHome, WEB_INF_LIB);
        if (libFolder.exists()) {
            FileUtils.cleanDirectory((File)libFolder);
            log.info("cleaning {}", (Object)libFolder);
        }
        this.completed.set(75.0);
        this.status.set("Extracting files");
        ZipFile zip = new ZipFile(warArchive.toFile());
        Enumeration<? extends ZipEntry> entries = zip.entries();
        block14: while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            String folder = name.substring(0, name.lastIndexOf(47) + 1);
            if (entry.isDirectory()) continue;
            switch (folder) {
                case "WEB-INF/": {
                    if (!this.replaceWebXml) continue block14;
                    this.writeFile(appNGHome, zip.getInputStream(entry), name);
                    continue block14;
                }
                case "WEB-INF/lib/": 
                case "WEB-INF/classes/": {
                    this.writeFile(appNGHome, zip.getInputStream(entry), name);
                    continue block14;
                }
                case "WEB-INF/conf/": {
                    if (!this.replacePlatformContext || !name.endsWith("platformContext.xml")) continue block14;
                    this.writeFile(appNGHome, zip.getInputStream(entry), name);
                    continue block14;
                }
                case "WEB-INF//bin/": {
                    if (!this.replaceBin) continue block14;
                    this.writeFile(appNGHome, zip.getInputStream(entry), name);
                    continue block14;
                }
            }
            log.info("Skipping {}", (Object)name);
        }
        zip.close();
        warArchive.toFile().delete();
        this.completed.set(80.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateAppNGizer(Resource resource, String appNGizerHome) throws RestClientException, IOException {
        if (!resource.exists() || !new File(appNGizerHome).exists()) {
            return;
        }
        Path warArchive = Files.createTempFile(null, null, new FileAttribute[0]);
        try (FileOutputStream out = new FileOutputStream(warArchive.toFile());
             InputStream is = resource.getInputStream();){
            IOUtils.copy((InputStream)is, (OutputStream)out);
            try (ZipFile zip = new ZipFile(warArchive.toFile());){
                Enumeration<? extends ZipEntry> entries = zip.entries();
                block40: while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String name = entry.getName();
                    String folder = name.substring(0, name.lastIndexOf(47) + 1);
                    if (entry.isDirectory()) continue;
                    if (folder.startsWith(WEB_INF_CLASSES)) {
                        this.writeFile(appNGizerHome, zip.getInputStream(entry), name);
                        continue;
                    }
                    switch (folder) {
                        case "WEB-INF/": {
                            if ("WEB-INF/web.xml".equals(name)) continue block40;
                            this.writeFile(appNGizerHome, zip.getInputStream(entry), name);
                            continue block40;
                        }
                        case "META-INF/": {
                            if (!"META-INF/MANIFEST.MF".equals(name)) continue block40;
                            this.writeFile(appNGizerHome, zip.getInputStream(entry), name);
                            continue block40;
                        }
                        case "WEB-INF/lib/": {
                            this.writeFile(appNGizerHome, zip.getInputStream(entry), name);
                            continue block40;
                        }
                    }
                    log.info("Skipping {}", (Object)name);
                }
            }
        }
        finally {
            warArchive.toFile().delete();
        }
    }

    private void writeFile(String parentFolder, InputStream is, String name) throws IOException, FileNotFoundException {
        byte[] data = IOUtils.toByteArray((InputStream)is);
        File targetFile = new File(parentFolder, name);
        String normalizedName = FilenameUtils.normalize((String)targetFile.getAbsolutePath());
        targetFile.getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(normalizedName);
        IOUtils.write((byte[])data, (OutputStream)fos);
        fos.close();
        log.info("wrote {}", (Object)normalizedName);
    }

    protected Container getAppNGContext() {
        return this.getHost().findChild("");
    }

    protected Container getAppNGizerContext() {
        return this.getHost().findChild("/appNGizer");
    }

    private Host getHost() {
        return (Host)this.context.getAttribute("host");
    }
}

