/*
 * Decompiled with CFR 0.152.
 */
package org.appops.cache.impl;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.appops.cache.event.Condition;
import org.appops.cache.event.EventSubscriber;
import org.appops.cache.event.SubscriberRegistry;

public class SubscriberRegistryImpl
implements SubscriberRegistry {
    private Table<String, Condition, Set<String>> subscriberListenerTable = HashBasedTable.create();
    private static final Condition DEFAULT = new Condition();
    private Logger logger = Logger.getLogger(this.getClass().getCanonicalName());

    public Boolean register(EventSubscriber eventSubscriber) {
        String serviceUrl = eventSubscriber.getServiceUrl();
        String serviceName = eventSubscriber.getServiceName();
        String serviceSubscriber = eventSubscriber.getSubscriber().getMethodName();
        String eventType = eventSubscriber.getSubscriber().getParameterType();
        Condition condition = eventSubscriber.getCondition();
        if (condition == null) {
            condition = DEFAULT;
        }
        String subscriberUrl = this.generateSubscriberUrl(serviceUrl, serviceName, serviceSubscriber);
        try {
            return this.addListener(eventType, condition, subscriberUrl);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Exception occured in " + this.getClass() + "::register()" + e);
            return false;
        }
    }

    private boolean addListener(String eventType, Condition condition, String subscriber) {
        return this.getSubscribers(eventType, condition).add(subscriber);
    }

    private String generateSubscriberUrl(String serviceUrl, String serviceName, String serviceSubscriber) {
        if (!serviceUrl.endsWith("/")) {
            serviceUrl = serviceUrl.concat("/");
        }
        return serviceUrl + "Op/" + serviceName + "/" + serviceSubscriber;
    }

    public Set<String> getSubscribers(String eventType, Condition condition) {
        HashSet listeners = (HashSet)this.subscriberListenerTable.get((Object)eventType, (Object)(condition = condition == null ? DEFAULT : condition));
        if (listeners == null) {
            listeners = new HashSet();
            this.subscriberListenerTable.put((Object)eventType, (Object)condition, listeners);
        }
        return (Set)this.subscriberListenerTable.get((Object)eventType, (Object)condition);
    }
}

