/*
 * Decompiled with CFR 0.152.
 */
package org.appops.cache.impl;

import com.google.inject.Inject;
import java.util.Set;
import org.appops.cache.event.Condition;
import org.appops.cache.event.EventSubscriber;
import org.appops.cache.event.ServiceEvent;
import org.appops.cache.event.SubscriberRegistry;
import org.appops.cache.slim.ServiceBus;
import org.appops.core.mime.MimeType;
import org.appops.core.service.OpParameterMap;
import org.appops.marshaller.DescriptorType;
import org.appops.marshaller.Marshaller;
import org.appops.web.common.client.WebClient;

public class ServiceBusImpl
implements ServiceBus {
    private SubscriberRegistry subscriberRegistry;
    private Marshaller marshaller;
    private WebClient<?> webClient;

    public ServiceBusImpl() {
    }

    @Inject
    public ServiceBusImpl(SubscriberRegistry subscriberRegistry) {
        this.subscriberRegistry = subscriberRegistry;
    }

    public Boolean register(EventSubscriber eventSubscriber) {
        return this.subscriberRegistry.register(eventSubscriber);
    }

    public void fireEvent(ServiceEvent event) {
        this.fireEvent(event, null);
    }

    public void fireEvent(ServiceEvent event, Condition condition) {
        String eventType = event.getEventType();
        Set subscribers = this.subscriberRegistry.getSubscribers(eventType, condition);
        String eventResultJson = this.marshaller.marshall((Object)event, DescriptorType.JSON);
        for (String subscriberUrl : subscribers) {
            String urlParameters = this.populateOpParamMapJson(eventResultJson);
            this.webClient.post(subscriberUrl, (Object)urlParameters, MimeType.JSON);
        }
    }

    private String populateOpParamMapJson(String json) {
        OpParameterMap map = new OpParameterMap();
        map.addParameter(Integer.valueOf(0), "eventResult", (Object)json);
        return this.getMarshaller().marshall((Object)map, DescriptorType.JSON);
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    @Inject
    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public WebClient<?> getWebClient() {
        return this.webClient;
    }

    @Inject
    public void setWebClient(WebClient webClient) {
        this.webClient = webClient;
    }
}

