/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.tsgen;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import org.appops.core.ClassPathAnalyser;
import org.appops.core.exception.CoreException;
import org.appops.core.service.annotation.Service;
import org.appops.tsgen.jackson.module.DefinitionGenerator;
import org.appops.tsgen.jackson.module.grammar.Module;

public class TypeScriptGenerator {


  /**
   * Generates single typescript file containing typescript interfaces definition created from
   * service definition.
   * 
   * @param serviceAnnotation Service annotation to locate interfaces for typescript conversion.
   * @param tsOutputDir Output generation directory.
   * @throws IOException An exception occurred while writing typescript.
   */
  public void generateTypeScript(Class<? extends Annotation> serviceAnnotation, File tsOutputDir)
      throws IOException {

  }

  /**
   * Generates single typescript file containing typescript interfaces definition created from
   * service definition.
   * 
   * @param classes Colelction of classes which are to be exported to typescript.
   * @param serviceAnnotation Service annotation to locate interfaces for typescript conversion.
   * @param tsOutputDir Output generation directory.
   * @throws IOException An exception occurred while writing typescript.
   */
  public void generateTypeScript(Collection<Class<?>> classes,
      Class<? extends Annotation> serviceAnnotation, File tsOutputDir) throws IOException {
    if (!serviceAnnotation.isAnnotationPresent(Service.class)) {
      throw new CoreException(
          "Invalid service annoration -> " + serviceAnnotation.getCanonicalName()
              + ", annotate it with -> " + Service.class.getCanonicalName());
    }

    String serviceName = serviceAnnotation.getSimpleName();


    ObjectMapper mapper = new ObjectMapper();
    DefinitionGenerator dg = new DefinitionGenerator(mapper);

    // retrieve the set of classes annotated with JSTYPE
    ClassPathAnalyser scanner = new ClassPathAnalyser();

    if (classes == null || classes.isEmpty()) {
      classes = new HashSet<>();
      classes.addAll(scanner.getAnnotatedTypes(serviceAnnotation));
    }

    FileWriter fw = new FileWriter(tsOutputDir.getPath() + "/" + serviceName + ".d.ts");

    Module m = dg.generateTypeScript(serviceName, classes, null);

    m.write(fw);

  }

}
