/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.tsgen.jackson.module.visitors;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonMapFormatVisitor;
import org.appops.tsgen.jackson.module.Configuration;
import org.appops.tsgen.jackson.module.grammar.MapType;


public class TsJsonMapFormatVisitor extends BaseTsJsonFormatVisitor<MapType>
    implements JsonMapFormatVisitor {

  public TsJsonMapFormatVisitor(BaseTsJsonFormatVisitor parentHolder, Configuration conf) {
    super(parentHolder, conf);
    type = new MapType();
  }

  public void keyFormat(JsonFormatVisitable handler, JavaType keyType) throws JsonMappingException {
    type.setKeyType(TsJsonFormatVisitorWrapper.getTsTypeForHandler(this, handler, keyType, conf));
  }

  public void valueFormat(JsonFormatVisitable handler, JavaType valueType)
      throws JsonMappingException {
    type.setValueType(
        TsJsonFormatVisitorWrapper.getTsTypeForHandler(this, handler, valueType, conf));
  }

}
