/*
 * Decompiled with CFR 0.152.
 */
package org.appops.tsgen;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import org.appops.core.ClassPathAnalyser;
import org.appops.core.exception.CoreException;
import org.appops.core.service.annotation.Service;
import org.appops.tsgen.jackson.module.DefinitionGenerator;
import org.appops.tsgen.jackson.module.grammar.Module;

public class TypeScriptGenerator {
    public void generateTypeScript(Class<? extends Annotation> serviceAnnotation, File tsOutputDir) throws IOException {
    }

    public void generateTypeScript(Collection<Class<?>> classes, Class<? extends Annotation> serviceAnnotation, File tsOutputDir) throws IOException {
        if (!serviceAnnotation.isAnnotationPresent(Service.class)) {
            throw new CoreException("Invalid service annoration -> " + serviceAnnotation.getCanonicalName() + ", annotate it with -> " + Service.class.getCanonicalName());
        }
        String serviceName = serviceAnnotation.getSimpleName();
        ObjectMapper mapper = new ObjectMapper();
        DefinitionGenerator dg = new DefinitionGenerator(mapper);
        ClassPathAnalyser scanner = new ClassPathAnalyser();
        if (classes == null || classes.isEmpty()) {
            classes = new HashSet();
            classes.addAll(scanner.getAnnotatedTypes(serviceAnnotation));
        }
        FileWriter fw = new FileWriter(tsOutputDir.getPath() + "/" + serviceName + ".d.ts");
        Module m = dg.generateTypeScript(serviceName, classes, null);
        m.write(fw);
    }
}

