/*
 * Decompiled with CFR 0.152.
 */
package org.appops.tsgen.jackson.module;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.SimpleType;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import org.appops.tsgen.jackson.module.Configuration;
import org.appops.tsgen.jackson.module.grammar.AnyType;
import org.appops.tsgen.jackson.module.grammar.ArrayType;
import org.appops.tsgen.jackson.module.grammar.BooleanType;
import org.appops.tsgen.jackson.module.grammar.EnumType;
import org.appops.tsgen.jackson.module.grammar.Module;
import org.appops.tsgen.jackson.module.grammar.NumberType;
import org.appops.tsgen.jackson.module.grammar.StaticClassType;
import org.appops.tsgen.jackson.module.grammar.StringType;
import org.appops.tsgen.jackson.module.grammar.base.AbstractType;
import org.appops.tsgen.jackson.module.grammar.base.Value;
import org.appops.tsgen.jackson.module.visitors.TsJsonFormatVisitorWrapper;

public class StaticFieldExporter {
    private static final String CLASS_NAME_EXTENSION = "Static";
    private final Module module;
    private final TsJsonFormatVisitorWrapper tsJsonFormatVisitorWrapper;

    public StaticFieldExporter(Module module, Configuration conf) {
        this.module = module;
        if (conf == null) {
            conf = new Configuration();
        }
        this.tsJsonFormatVisitorWrapper = new TsJsonFormatVisitorWrapper(module, conf);
    }

    public void export(List<Class<?>> classesToConvert) throws IllegalArgumentException {
        for (Class<?> clazz : classesToConvert) {
            Field[] declaredFields;
            if (clazz.isEnum()) continue;
            StaticClassType staticClass = new StaticClassType(clazz.getSimpleName() + CLASS_NAME_EXTENSION);
            for (Field field : declaredFields = clazz.getDeclaredFields()) {
                Value value;
                if (!this.isPublicStaticFinal(field.getModifiers())) continue;
                try {
                    value = this.constructValue(this.module, field.getType(), field.get(null));
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Failed to get value of field " + field, e);
                }
                if (value == null) continue;
                staticClass.getStaticFields().put(field.getName(), value);
            }
            if (staticClass.getStaticFields().size() <= 0) continue;
            this.module.getNamedTypes().put(staticClass.getName(), staticClass);
        }
    }

    private boolean isPublicStaticFinal(int modifiers) {
        return Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers);
    }

    private Value constructValue(Module module, Class<?> type, Object rawValue) throws IllegalArgumentException, IllegalAccessException {
        if (type == Boolean.TYPE) {
            return new Value(BooleanType.getInstance(), rawValue);
        }
        if (type == Integer.TYPE) {
            return new Value(NumberType.getInstance(), rawValue);
        }
        if (type == Double.TYPE) {
            return new Value(NumberType.getInstance(), rawValue);
        }
        if (type == String.class) {
            return new Value(StringType.getInstance(), "'" + (String)rawValue + "'");
        }
        if (type.isEnum()) {
            EnumType enumType = this.tsJsonFormatVisitorWrapper.parseEnumOrGetFromCache(module, (JavaType)SimpleType.construct(type));
            return new Value(enumType, enumType.getName() + "." + rawValue);
        }
        if (type.isArray()) {
            int i;
            Object[] array;
            Object[] tmpArray;
            Class<?> componentType = type.getComponentType();
            if (componentType == Boolean.TYPE) {
                tmpArray = (boolean[])rawValue;
                array = new Boolean[tmpArray.length];
                for (i = 0; i < array.length; ++i) {
                    array[i] = tmpArray[i];
                }
            } else if (componentType == Integer.TYPE) {
                tmpArray = (int[])rawValue;
                array = new Integer[tmpArray.length];
                for (i = 0; i < array.length; ++i) {
                    array[i] = tmpArray[i];
                }
            } else if (componentType == Double.TYPE) {
                tmpArray = (double[])rawValue;
                array = new Double[tmpArray.length];
                for (i = 0; i < array.length; ++i) {
                    array[i] = (double)tmpArray[i];
                }
            } else {
                array = (Object[])rawValue;
            }
            StringBuilder arrayValues = new StringBuilder();
            arrayValues.append("[ ");
            for (i = 0; i < array.length; ++i) {
                arrayValues.append(this.constructValue(module, componentType, array[i]).getValue());
                if (i >= array.length - 1) continue;
                arrayValues.append(", ");
            }
            arrayValues.append(" ]");
            return new Value(new ArrayType(this.typeScriptTypeFromJavaType(module, componentType)), arrayValues.toString());
        }
        return null;
    }

    private AbstractType typeScriptTypeFromJavaType(Module module, Class<?> type) {
        if (type == Boolean.TYPE) {
            return BooleanType.getInstance();
        }
        if (type == Integer.TYPE) {
            return NumberType.getInstance();
        }
        if (type == Double.TYPE) {
            return NumberType.getInstance();
        }
        if (type == String.class) {
            return StringType.getInstance();
        }
        if (type.isEnum()) {
            return this.tsJsonFormatVisitorWrapper.parseEnumOrGetFromCache(module, (JavaType)SimpleType.construct(type));
        }
        if (type.isArray()) {
            return new ArrayType(AnyType.getInstance());
        }
        throw new UnsupportedOperationException();
    }
}

